/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.IgnoreDecider;
import net.sourceforge.fullsync.RuleSet;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskGenerationListener;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.impl.AbstractTaskGenerator;
import net.sourceforge.fullsync.impl.BufferStateDecider;
import net.sourceforge.fullsync.impl.StateDecider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGeneratorImpl
extends AbstractTaskGenerator {
    private static final Logger logger = LoggerFactory.getLogger((String)TaskGeneratorImpl.class.getSimpleName());
    private IgnoreDecider takeIgnoreDecider;
    private StateDecider stateDecider;
    private BufferStateDecider bufferStateDecider;

    protected RuleSet updateRules(File src, File dst, RuleSet rules) throws DataParseException, IOException {
        rules = rules.createChild(src, dst);
        this.takeIgnoreDecider = rules;
        this.stateDecider = new StateDecider(rules);
        this.bufferStateDecider = new BufferStateDecider(rules);
        return rules;
    }

    protected void recurse(File src, File dst, RuleSet rules, Task parent) throws DataParseException, IOException {
        if (src.isDirectory() && dst.isDirectory()) {
            this.synchronizeDirectories(src, dst, rules, parent);
        }
    }

    @Override
    public void synchronizeNodes(File src, File dst, RuleSet rules, Task parent) throws DataParseException, IOException {
        if (!this.takeIgnoreDecider.isNodeIgnored(src)) {
            for (TaskGenerationListener listener : this.taskGenerationListeners) {
                listener.taskGenerationStarted(src, dst);
            }
            Task task = this.getActionDecider().getTask(src, dst, this.stateDecider, this.bufferStateDecider);
            logger.debug(src.getName() + ": " + task);
            for (TaskGenerationListener listener : this.taskGenerationListeners) {
                listener.taskGenerationFinished(task);
            }
            if (rules.isUsingRecursion()) {
                this.recurse(src, dst, rules, task);
            }
            parent.addChild(task);
        }
    }

    @Override
    public void synchronizeDirectories(File src, File dst, RuleSet oldrules, Task parent) throws DataParseException, IOException {
        RuleSet rules = this.updateRules(src, dst, oldrules);
        Collection<File> srcFiles = src.getChildren();
        ArrayList<File> dstFiles = new ArrayList<File>(dst.getChildren());
        for (File sfile : srcFiles) {
            File dfile = dst.getChild(sfile.getName());
            if (dfile == null) {
                dfile = dst.createChild(sfile.getName(), sfile.isDirectory());
            } else {
                dstFiles.remove(dfile);
            }
            this.synchronizeNodes(sfile, dfile, rules, parent);
        }
        for (File dfile : dstFiles) {
            File sfile = src.getChild(dfile.getName());
            if (sfile == null) {
                sfile = src.createChild(dfile.getName(), dfile.isDirectory());
            }
            this.synchronizeNodes(sfile, dfile, rules, parent);
        }
        this.takeIgnoreDecider = oldrules;
        this.stateDecider = new StateDecider(oldrules);
        this.bufferStateDecider = new BufferStateDecider(oldrules);
    }
}

