/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.impl;

import java.io.IOException;
import java.util.Vector;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.ActionDecider;
import net.sourceforge.fullsync.BufferStateDecider;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.State;
import net.sourceforge.fullsync.StateDecider;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.fs.File;

public class TwoWaySyncActionDecider
implements ActionDecider {
    private static final Action addToDestination = new Action(1, 2, 2, "Add");
    private static final Action addToSource = new Action(1, 1, 1, "Add");
    private static final Action updateDestination = new Action(2, 2, 2, "source changed, update destination");
    private static final Action updateSource = new Action(2, 1, 1, "destination changed, update source");
    private static final Action overwriteDestination = new Action(2, 2, 2, "overwrite destination changes");
    private static final Action overwriteSource = new Action(2, 1, 1, "overwrite source changes");
    private static final Action deleteDestinationOrphan = new Action(3, 2, 2, "Delete orphan in destination", false);
    private static final Action deleteSourceOrphan = new Action(3, 1, 1, "Delete orphan in source", false);
    private static final Action inSync = new Action(0, 0, 0, "In Sync");
    private static final Action ignore = new Action(0, 0, 0, "Ignore");

    @Override
    public Task getTask(File src, File dst, StateDecider sd, BufferStateDecider bsd) throws DataParseException, IOException {
        Vector<Action> actions = new Vector<Action>(3);
        State state = sd.getState(src, dst);
        switch (state.getType()) {
            case 2: {
                if (state.getLocation() == 1) {
                    actions.add(addToDestination);
                    actions.add(deleteSourceOrphan);
                    break;
                }
                if (state.getLocation() != 2) break;
                actions.add(addToSource);
                actions.add(deleteDestinationOrphan);
                break;
            }
            case 4: {
                actions.add(new Action(12, state.getLocation(), 0, "file changed from/to dir, can't overwrite"));
                break;
            }
            case 3: {
                if (state.getLocation() == 1) {
                    actions.add(updateDestination);
                    actions.add(overwriteSource);
                    break;
                }
                if (state.getLocation() != 2) break;
                actions.add(updateSource);
                actions.add(overwriteDestination);
                break;
            }
            case 1: {
                actions.add(inSync);
                actions.add(overwriteDestination);
                actions.add(overwriteSource);
                break;
            }
            default: {
                actions.add(new Action(10, 0, 0, "no rule found"));
            }
        }
        actions.add(ignore);
        Action[] as = new Action[actions.size()];
        actions.toArray(as);
        return new Task(src, dst, state, as);
    }
}

