/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.remote;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.remote.RemoteServer;

public class RemoteController {
    private static RemoteController instance;
    private RemoteServer remoteServer;
    private String serverURL;
    private int port;
    private String password;
    private boolean isActive = false;
    private Registry registry = null;

    public static RemoteController getInstance() {
        if (instance == null) {
            instance = new RemoteController();
        }
        return instance;
    }

    public void startServer(int port, String password, ProfileManager profileManager, Synchronizer sync) throws RemoteException {
        try {
            this.port = port;
            this.serverURL = "rmi://localhost:" + port + "/FullSync";
            this.password = password;
            if (this.remoteServer == null) {
                this.remoteServer = new RemoteServer(profileManager, sync);
                this.remoteServer.setPassword(password);
            }
            if (this.registry == null) {
                this.registry = LocateRegistry.createRegistry(port);
            }
            Naming.rebind(this.serverURL, this.remoteServer);
            this.isActive = true;
        }
        catch (MalformedURLException e) {
            ExceptionHandler.reportException(e);
        }
    }

    public void stopServer() throws RemoteException {
        if (!this.isActive) {
            return;
        }
        try {
            Naming.unbind(this.serverURL);
            this.isActive = false;
        }
        catch (MalformedURLException e) {
            ExceptionHandler.reportException(e);
        }
        catch (NotBoundException e) {
            ExceptionHandler.reportException(e);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.remoteServer.setPassword(password);
    }
}

