/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.remote;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileListChangeListener;
import net.sourceforge.fullsync.TaskFinishedListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.remote.RemoteInterface;
import net.sourceforge.fullsync.remote.RemoteProfileListChangeListener;
import net.sourceforge.fullsync.remote.RemoteSchedulerChangeListener;
import net.sourceforge.fullsync.remote.RemoteTaskFinishedListener;
import net.sourceforge.fullsync.schedule.SchedulerChangeListener;

public class RemoteManager {
    private RemoteInterface remoteInterface;
    private HashMap<Object, UnicastRemoteObject> listenersMap = new HashMap();
    private boolean useRemoteListener = false;

    public RemoteManager(String host, int port, String password) throws MalformedURLException, RemoteException, NotBoundException {
        this.remoteInterface = (RemoteInterface)Naming.lookup("rmi://" + host + ":" + port + "/FullSync");
        if (!this.remoteInterface.checkPassword(password)) {
            throw new RemoteException("Wrong password");
        }
    }

    public Profile[] getProfiles() {
        try {
            Profile[] remoteprofiles = this.remoteInterface.getProfiles();
            return remoteprofiles;
        }
        catch (RemoteException e) {
            ExceptionHandler.reportException(e);
            return null;
        }
    }

    public void addProfileListChangeListener(ProfileListChangeListener listener) throws RemoteException {
        if (listener != null) {
            RemoteProfileListChangeListener remoteListener = new RemoteProfileListChangeListener(listener);
            this.remoteInterface.addProfileListChangeListener(remoteListener);
            this.listenersMap.put(listener, remoteListener);
        }
    }

    public void removeProfileListChangeListener(ProfileListChangeListener listener) throws RemoteException {
        if (listener != null) {
            RemoteProfileListChangeListener remoteListener = (RemoteProfileListChangeListener)this.listenersMap.remove(listener);
            this.remoteInterface.removeProfileListChangeListener(remoteListener);
        }
    }

    public void addSchedulerChangeListener(SchedulerChangeListener listener) throws RemoteException {
        RemoteSchedulerChangeListener remoteListener = new RemoteSchedulerChangeListener(listener);
        this.remoteInterface.addSchedulerChangeListener(remoteListener);
        this.listenersMap.put(listener, remoteListener);
    }

    public void removeSchedulerChangeListener(SchedulerChangeListener listener) throws RemoteException {
        RemoteSchedulerChangeListener remoteListener = (RemoteSchedulerChangeListener)this.listenersMap.remove(listener);
        this.remoteInterface.removeSchedulerChangeListener(remoteListener);
    }

    public void startTimer() {
        try {
            this.remoteInterface.startTimer();
        }
        catch (RemoteException e) {
            ExceptionHandler.reportException(e);
        }
    }

    public void stopTimer() {
        try {
            this.remoteInterface.stopTimer();
        }
        catch (RemoteException e) {
            ExceptionHandler.reportException(e);
        }
    }

    public boolean isSchedulerEnabled() {
        try {
            return this.remoteInterface.isSchedulerEnabled();
        }
        catch (RemoteException e) {
            ExceptionHandler.reportException(e);
            return false;
        }
    }

    public TaskTree executeProfile(String name) throws RemoteException {
        return this.remoteInterface.executeProfile(name);
    }

    public void performActions(TaskTree taskTree, TaskFinishedListener listener) throws RemoteException {
        RemoteTaskFinishedListener remoteListener = null;
        if (this.useRemoteListener) {
            remoteListener = new RemoteTaskFinishedListener(listener);
        }
        this.remoteInterface.performActions(taskTree, remoteListener);
    }

    public void setUseRemoteListener(boolean bool) {
        this.useRemoteListener = bool;
    }

    public boolean getUseRemoteListener() {
        return this.useRemoteListener;
    }

    public void save(Profile[] profiles) throws RemoteException {
        this.remoteInterface.save(profiles);
    }

    public boolean isConnectedToRemoteInstance() throws RemoteException {
        return this.remoteInterface.isConnectedToRemoteInstance();
    }
}

