/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.remote;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.IoStatistics;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileListChangeListener;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.TaskFinishedEvent;
import net.sourceforge.fullsync.TaskFinishedListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.remote.RemoteInterface;
import net.sourceforge.fullsync.remote.RemoteProfileListChangeListenerInterface;
import net.sourceforge.fullsync.remote.RemoteSchedulerChangeListenerInterface;
import net.sourceforge.fullsync.remote.RemoteTaskFinishedListenerInterface;
import net.sourceforge.fullsync.schedule.SchedulerChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServer
extends UnicastRemoteObject
implements RemoteInterface {
    private static final long serialVersionUID = 2L;
    private ProfileManager profileManager;
    private Synchronizer synchronizer;
    private String password;
    private HashMap<Remote, Object> listenersMap = new HashMap();
    private Logger logger = LoggerFactory.getLogger((String)"FullSync");

    public RemoteServer(ProfileManager profileManager, Synchronizer synchronizer) throws RemoteException {
        this.profileManager = profileManager;
        this.synchronizer = synchronizer;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean checkPassword(String passwd) throws RemoteException {
        boolean check = this.password.equals(passwd);
        if (check) {
            this.logger.info("Received client connection on remote interface.");
        } else {
            this.logger.info("Client connection on remote interface rejected because of wrong password.");
        }
        return check;
    }

    @Override
    public Profile[] getProfiles() throws RemoteException {
        return this.profileManager.getProfiles().toArray(new Profile[0]);
    }

    @Override
    public void addProfileListChangeListener(final RemoteProfileListChangeListenerInterface remotelistener) throws RemoteException {
        ProfileListChangeListener listener = new ProfileListChangeListener(){

            @Override
            public void profileChanged(Profile profile) {
                try {
                    remotelistener.profileChanged(profile);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            @Override
            public void profileListChanged() {
                try {
                    remotelistener.profileListChanged();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        };
        this.profileManager.addProfilesChangeListener(listener);
        this.listenersMap.put(remotelistener, listener);
    }

    @Override
    public void removeProfileListChangeListener(RemoteProfileListChangeListenerInterface remoteListener) throws RemoteException {
        ProfileListChangeListener listener = (ProfileListChangeListener)this.listenersMap.remove(remoteListener);
        this.profileManager.removeProfilesChangeListener(listener);
    }

    @Override
    public void addSchedulerChangeListener(final RemoteSchedulerChangeListenerInterface remotelistener) throws RemoteException {
        SchedulerChangeListener listener = new SchedulerChangeListener(){

            @Override
            public void schedulerStatusChanged(boolean status) {
                try {
                    remotelistener.schedulerStatusChanged(status);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        };
        this.profileManager.addSchedulerChangeListener(listener);
        this.listenersMap.put(remotelistener, listener);
    }

    @Override
    public void removeSchedulerChangeListener(RemoteSchedulerChangeListenerInterface remoteListener) throws RemoteException {
        SchedulerChangeListener listener = (SchedulerChangeListener)this.listenersMap.remove(remoteListener);
        this.profileManager.removeSchedulerChangeListener(listener);
    }

    @Override
    public void startTimer() throws RemoteException {
        this.profileManager.startScheduler();
    }

    @Override
    public void stopTimer() throws RemoteException {
        this.profileManager.stopScheduler();
    }

    @Override
    public boolean isSchedulerEnabled() throws RemoteException {
        return this.profileManager.isSchedulerEnabled();
    }

    @Override
    public TaskTree executeProfile(String name) throws RemoteException {
        Profile p = this.profileManager.getProfile(name);
        TaskTree tree = this.synchronizer.executeProfile(p, false);
        return tree;
    }

    @Override
    public IoStatistics getIoStatistics(TaskTree taskTree) throws RemoteException {
        return this.synchronizer.getIoStatistics(taskTree);
    }

    @Override
    public void performActions(TaskTree tree, final RemoteTaskFinishedListenerInterface remoteListener) throws RemoteException {
        int result;
        TaskFinishedListener listener = null;
        if (remoteListener != null) {
            listener = new TaskFinishedListener(){

                @Override
                public void taskFinished(TaskFinishedEvent event) {
                    try {
                        remoteListener.taskFinished(event);
                    }
                    catch (RemoteException e) {
                        ExceptionHandler.reportException(e);
                    }
                }
            };
        }
        if ((result = this.synchronizer.performActions(tree, listener)) != 0) {
            throw new RemoteException("Exception while performing actions");
        }
    }

    @Override
    public void save(Profile[] profiles) throws RemoteException {
        for (Profile p : this.profileManager.getProfiles()) {
            boolean found = false;
            for (Profile profile : profiles) {
                if (!profile.getName().equals(p.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.profileManager.removeProfile(p);
        }
        for (Profile profile : profiles) {
            Profile p = this.profileManager.getProfile(profile.getName());
            if (p == null) {
                this.profileManager.addProfile(profile);
                continue;
            }
            p.setName(profile.getName());
            p.setDescription(profile.getDescription());
            p.setSource(profile.getSource());
            p.setDestination(profile.getDestination());
            p.setSynchronizationType(profile.getSynchronizationType());
            p.setRuleSet(profile.getRuleSet());
            p.setSchedule(profile.getSchedule());
            p.setEnabled(profile.isEnabled());
            this.profileManager.profileChanged(p);
        }
    }

    @Override
    public boolean isConnectedToRemoteInstance() {
        return this.profileManager.isConnectedToRemoteInstance();
    }
}

