/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import net.sourceforge.fullsync.SystemDate;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilterRuleNotAppliableException;
import net.sourceforge.fullsync.rules.filefilter.values.AgeValue;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class FileAgeFileFilterRule
extends FileFilterRule {
    private static final long serialVersionUID = 2L;
    public static String typeName = "File age";
    public static final int OP_IS = 0;
    public static final int OP_ISNT = 1;
    public static final int OP_IS_GREATER_THAN = 2;
    public static final int OP_IS_LESS_THAN = 3;
    private static final String[] allOperators = new String[]{"is", "isn't", "is greater than", "is less than"};
    private AgeValue age;
    private int op;

    @Override
    public String getRuleType() {
        return typeName;
    }

    public static String[] getAllOperators() {
        return allOperators;
    }

    public FileAgeFileFilterRule(AgeValue age, int operator) {
        this.age = age;
        this.op = operator;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public String getOperatorName() {
        return allOperators[this.op];
    }

    @Override
    public OperandValue getValue() {
        return this.age;
    }

    @Override
    public boolean match(File file) throws FilterRuleNotAppliableException {
        long lastModified = file.getLastModified();
        if (-1L == lastModified) {
            throw new FilterRuleNotAppliableException("The file or directory doesn't have any modification date");
        }
        long now = SystemDate.getInstance().currentTimeMillis();
        long delta = (long)(Math.floor((double)now / 1000.0) - Math.floor((double)lastModified / 1000.0));
        switch (this.op) {
            case 0: {
                return delta == this.age.getSeconds();
            }
            case 1: {
                return delta != this.age.getSeconds();
            }
            case 2: {
                return delta > this.age.getSeconds();
            }
            case 3: {
                return delta < this.age.getSeconds();
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append("file age ");
        buff.append(allOperators[this.op]);
        buff.append(" '");
        buff.append(this.age);
        buff.append("'");
        return buff.toString();
    }
}

