/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import java.io.Serializable;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilterRuleNotAppliableException;

public class FileFilter
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final int MATCH_ALL = 0;
    public static final int MATCH_ANY = 1;
    public static final int INCLUDE = 0;
    public static final int EXCLUDE = 1;
    private int match_type = 0;
    private int filter_type = 0;
    private boolean appliesToDir = true;
    private FileFilterRule[] rules = new FileFilterRule[0];

    public void setMatchType(int match_type) {
        this.match_type = match_type;
    }

    public int getMatchType() {
        return this.match_type;
    }

    public void setFilterType(int filter_type) {
        this.filter_type = filter_type;
    }

    public int getFilterType() {
        return this.filter_type;
    }

    public void setFileFilterRules(FileFilterRule[] rules) {
        this.rules = rules;
    }

    public void setAppliesToDirectories(boolean appliesToDir) {
        this.appliesToDir = appliesToDir;
    }

    public boolean appliesToDirectories() {
        return this.appliesToDir;
    }

    public FileFilterRule[] getFileFiltersRules() {
        return this.rules;
    }

    public boolean match(File file) {
        boolean result = this.doMmatch(file);
        return this.filter_type == 0 ? result : !result;
    }

    private boolean doMmatch(File file) {
        if (this.rules.length == 0) {
            return true;
        }
        switch (this.match_type) {
            case 0: {
                for (FileFilterRule rule : this.rules) {
                    if (!this.appliesToDir && file.isDirectory()) continue;
                    try {
                        boolean res = rule.match(file);
                        if (res) continue;
                        return false;
                    }
                    catch (FilterRuleNotAppliableException res) {
                        // empty catch block
                    }
                }
                return true;
            }
            case 1: {
                int applyedRules = 0;
                for (FileFilterRule rule : this.rules) {
                    if (!this.appliesToDir && file.isDirectory()) continue;
                    try {
                        boolean res = rule.match(file);
                        if (res) {
                            return true;
                        }
                        ++applyedRules;
                    }
                    catch (FilterRuleNotAppliableException filterRuleNotAppliableException) {
                        // empty catch block
                    }
                }
                return applyedRules == 0;
            }
        }
        return true;
    }

    public String toString() {
        if (this.rules.length == 0) {
            return "Empty filter";
        }
        StringBuffer buff = new StringBuffer(25 + 30 * this.rules.length);
        switch (this.filter_type) {
            case 0: {
                buff.append("Include");
                break;
            }
            case 1: {
                buff.append("Exclude");
            }
        }
        buff.append(" any file where ");
        block8: for (int i = 0; i < this.rules.length - 1; ++i) {
            buff.append(this.rules[i].toString());
            switch (this.match_type) {
                case 0: {
                    buff.append(" and ");
                    continue block8;
                }
                case 1: {
                    buff.append(" or ");
                }
            }
        }
        if (this.rules.length > 0) {
            buff.append(this.rules[this.rules.length - 1].toString());
        }
        return buff.toString();
    }
}

