/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import net.sourceforge.fullsync.rules.filefilter.FileAgeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileModificationDateFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileNameFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilePathFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileSizeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FileTypeFileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.SubfilterFileFilerRule;
import net.sourceforge.fullsync.rules.filefilter.values.AgeValue;
import net.sourceforge.fullsync.rules.filefilter.values.DateValue;
import net.sourceforge.fullsync.rules.filefilter.values.FilterValue;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.rules.filefilter.values.SizeValue;
import net.sourceforge.fullsync.rules.filefilter.values.TextValue;
import net.sourceforge.fullsync.rules.filefilter.values.TypeValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileFilterManager {
    public Element serializeFileFilter(FileFilter fileFilter, Document document, String elementName, String ruleElementName) {
        FileFilterRule[] rules;
        Element filterElement = document.createElement(elementName);
        filterElement.setAttribute("matchtype", String.valueOf(fileFilter.getMatchType()));
        filterElement.setAttribute("filtertype", String.valueOf(fileFilter.getFilterType()));
        filterElement.setAttribute("appliestodir", String.valueOf(fileFilter.appliesToDirectories()));
        for (FileFilterRule rule : rules = fileFilter.getFileFiltersRules()) {
            Element ruleElement = this.serializeRule(rule, document, ruleElementName);
            filterElement.appendChild(ruleElement);
        }
        return filterElement;
    }

    public Element serializeRule(FileFilterRule fileFilterRule, Document document, String elementName) {
        Element ruleElement = document.createElement(elementName);
        String ruleType = fileFilterRule != null ? fileFilterRule.getRuleType() : null;
        ruleElement.setAttribute("ruletype", ruleType);
        this.serializeRuleAttributes(fileFilterRule, ruleElement);
        return ruleElement;
    }

    public FileFilter unserializeFileFilter(Element fileFilterElement, String ruleElementName) {
        FileFilter fileFilter = new FileFilter();
        int matchType = 0;
        try {
            matchType = Integer.parseInt(fileFilterElement.getAttribute("matchtype"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        fileFilter.setMatchType(matchType);
        int filterType = 0;
        try {
            filterType = Integer.parseInt(fileFilterElement.getAttribute("filtertype"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        fileFilter.setFilterType(filterType);
        boolean applies = Boolean.valueOf(fileFilterElement.getAttribute("appliestodir"));
        fileFilter.setAppliesToDirectories(applies);
        NodeList ruleList = fileFilterElement.getElementsByTagName(ruleElementName);
        int numOfRules = ruleList.getLength();
        FileFilterRule[] rules = new FileFilterRule[numOfRules];
        for (int i = 0; i < rules.length; ++i) {
            rules[i] = this.unserializeFileFilterRule((Element)ruleList.item(i));
        }
        fileFilter.setFileFilterRules(rules);
        return fileFilter;
    }

    private void serializeRuleAttributes(FileFilterRule fileFilterRule, Element ruleElement) {
        FileFilterRule rule;
        if (fileFilterRule instanceof FileNameFileFilterRule) {
            rule = (FileNameFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FileNameFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("pattern", ((FileNameFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof FilePathFileFilterRule) {
            rule = (FilePathFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FilePathFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("pattern", ((FilePathFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof FileTypeFileFilterRule) {
            rule = (FileTypeFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FileTypeFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("type", ((FileTypeFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof FileSizeFileFilterRule) {
            rule = (FileSizeFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FileSizeFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("size", ((FileSizeFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof FileModificationDateFileFilterRule) {
            rule = (FileModificationDateFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FileModificationDateFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("modificationdate", ((FileModificationDateFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof FileAgeFileFilterRule) {
            rule = (FileAgeFileFilterRule)fileFilterRule;
            ruleElement.setAttribute("op", String.valueOf(((FileAgeFileFilterRule)rule).getOperator()));
            ruleElement.setAttribute("age", ((FileAgeFileFilterRule)rule).getValue().toString());
        }
        if (fileFilterRule instanceof SubfilterFileFilerRule) {
            rule = (SubfilterFileFilerRule)fileFilterRule;
            FileFilter subfilter = ((FilterValue)((SubfilterFileFilerRule)rule).getValue()).getValue();
            Element subfilterElement = this.serializeFileFilter(subfilter, ruleElement.getOwnerDocument(), "NestedFileFilter", "NestedFileFilterRule");
            ruleElement.appendChild(subfilterElement);
        }
    }

    public FileFilterRule unserializeFileFilterRule(Element fileFilterRuleElement) {
        String pattern;
        int op;
        FileFilterRule rule = null;
        String ruleType = fileFilterRuleElement.getAttribute("ruletype");
        if (ruleType.equals(FileNameFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            pattern = fileFilterRuleElement.getAttribute("pattern");
            rule = new FileNameFileFilterRule(new TextValue(pattern), op);
        }
        if (ruleType.equals(FilePathFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            pattern = fileFilterRuleElement.getAttribute("pattern");
            rule = new FilePathFileFilterRule(new TextValue(pattern), op);
        }
        if (ruleType.equals(FileTypeFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            String type = fileFilterRuleElement.getAttribute("type");
            rule = new FileTypeFileFilterRule(new TypeValue(type), op);
        }
        if (ruleType.equals(FileSizeFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            String size = fileFilterRuleElement.getAttribute("size");
            rule = new FileSizeFileFilterRule(new SizeValue(size), op);
        }
        if (ruleType.equals(FileModificationDateFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            String date = fileFilterRuleElement.getAttribute("modificationdate");
            rule = new FileModificationDateFileFilterRule(new DateValue(date), op);
        }
        if (ruleType.equals(FileAgeFileFilterRule.typeName)) {
            op = Integer.parseInt(fileFilterRuleElement.getAttribute("op"));
            String age = fileFilterRuleElement.getAttribute("age");
            rule = new FileAgeFileFilterRule(new AgeValue(age), op);
        }
        if (ruleType.equals(SubfilterFileFilerRule.typeName)) {
            NodeList filterList = fileFilterRuleElement.getElementsByTagName("NestedFileFilter");
            Element subfileFilerElement = (Element)filterList.item(0);
            FileFilter fileFiler = this.unserializeFileFilter(subfileFilerElement, "NestedFileFilterRule");
            rule = new SubfilterFileFilerRule(fileFiler);
        }
        return rule;
    }

    public FileFilterRule createFileFilterRule(String ruleType, int op, OperandValue value) {
        TextValue textValue;
        FileFilterRule rule = null;
        if (ruleType.equals(FileNameFileFilterRule.typeName)) {
            textValue = (TextValue)value;
            rule = new FileNameFileFilterRule(textValue, op);
        }
        if (ruleType.equals(FilePathFileFilterRule.typeName)) {
            textValue = (TextValue)value;
            rule = new FilePathFileFilterRule(textValue, op);
        }
        if (ruleType.equals(FileTypeFileFilterRule.typeName)) {
            TypeValue fileTypeValue = (TypeValue)value;
            rule = new FileTypeFileFilterRule(fileTypeValue, op);
        }
        if (ruleType.equals(FileSizeFileFilterRule.typeName)) {
            SizeValue size = (SizeValue)value;
            rule = new FileSizeFileFilterRule(size, op);
        }
        if (ruleType.equals(FileModificationDateFileFilterRule.typeName)) {
            DateValue date = (DateValue)value;
            rule = new FileModificationDateFileFilterRule(date, op);
        }
        if (ruleType.equals(FileAgeFileFilterRule.typeName)) {
            AgeValue age = (AgeValue)value;
            rule = new FileAgeFileFilterRule(age, op);
        }
        if (ruleType.equals(SubfilterFileFilerRule.typeName)) {
            FilterValue filterValue = (FilterValue)value;
            rule = new SubfilterFileFilerRule(filterValue.getValue());
        }
        return rule;
    }

    public String[] getOperatorsForRuleType(String ruleType) {
        if (ruleType.equals(FileNameFileFilterRule.typeName)) {
            return FileNameFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(FilePathFileFilterRule.typeName)) {
            return FilePathFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(FileTypeFileFilterRule.typeName)) {
            return FileTypeFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(FileSizeFileFilterRule.typeName)) {
            return FileSizeFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(FileModificationDateFileFilterRule.typeName)) {
            return FileModificationDateFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(FileAgeFileFilterRule.typeName)) {
            return FileAgeFileFilterRule.getAllOperators();
        }
        if (ruleType.equals(SubfilterFileFilerRule.typeName)) {
            return new String[0];
        }
        return new String[]{"N/A"};
    }
}

