/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilterRuleNotAppliableException;
import net.sourceforge.fullsync.rules.filefilter.values.DateValue;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class FileModificationDateFileFilterRule
extends FileFilterRule {
    private static final long serialVersionUID = 2L;
    public static String typeName = "File modification date";
    public static final int OP_IS = 0;
    public static final int OP_ISNT = 1;
    public static final int OP_IS_BEFORE = 2;
    public static final int OP_IS_AFTER = 3;
    private static final String[] allOperators = new String[]{"is", "isn't", "is before", "is after"};
    private DateValue date;
    private int op;

    @Override
    public String getRuleType() {
        return typeName;
    }

    public static String[] getAllOperators() {
        return allOperators;
    }

    public FileModificationDateFileFilterRule(DateValue date, int operator) {
        this.date = date;
        this.op = operator;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public String getOperatorName() {
        return allOperators[this.op];
    }

    @Override
    public OperandValue getValue() {
        return this.date;
    }

    @Override
    public boolean match(File file) throws FilterRuleNotAppliableException {
        long lastModified = file.getLastModified();
        if (-1L == lastModified) {
            throw new FilterRuleNotAppliableException("The file or directory doesn't have any modification date");
        }
        switch (this.op) {
            case 0: {
                return this.date.equals(lastModified);
            }
            case 1: {
                return !this.date.equals(lastModified);
            }
            case 2: {
                return this.date.isBefore(lastModified);
            }
            case 3: {
                return this.date.isAfter(lastModified);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append("file modification date ");
        buff.append(allOperators[this.op]);
        buff.append(" '");
        buff.append(this.date);
        buff.append("'");
        return buff.toString();
    }
}

