/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.rules.filefilter.values.TextValue;

public class FilePathFileFilterRule
extends FileFilterRule {
    private static final long serialVersionUID = 2L;
    public static String typeName = "File path";
    public static final int OP_IS = 0;
    public static final int OP_ISNT = 1;
    public static final int OP_CONTAINS = 2;
    public static final int OP_DOESNT_CONTAINS = 3;
    public static final int OP_BEGINS_WITH = 4;
    public static final int OP_DOESNT_BEGINS_WITH = 5;
    public static final int OP_ENDS_WITH = 6;
    public static final int OP_DOESNT_ENDS_WITH = 7;
    public static final int OP_MATCHES_REGEXP = 8;
    public static final int OP_DOESNT_MATCHES_REGEXP = 9;
    private static final String[] allOperators = new String[]{"is", "isn't", "contains", "doesn't contains", "begins with", "doesn't begins with", "ends with", "doesn't ends with", "matches regexp", "doesn't matches regexp"};
    private TextValue pattern;
    private int op;
    private Pattern regexppattern;

    @Override
    public String getRuleType() {
        return typeName;
    }

    public static String[] getAllOperators() {
        return allOperators;
    }

    public FilePathFileFilterRule(TextValue pattern, int operator) {
        this.pattern = pattern;
        this.op = operator;
        if (operator == 8 || operator == 9) {
            try {
                this.regexppattern = Pattern.compile(this.pattern.getValue());
            }
            catch (PatternSyntaxException e) {
                this.pattern.setValue("");
                ExceptionHandler.reportException(e);
            }
        }
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public String getOperatorName() {
        return allOperators[this.op];
    }

    @Override
    public OperandValue getValue() {
        return this.pattern;
    }

    @Override
    public boolean match(File file) {
        String name = file.getPath();
        switch (this.op) {
            case 0: {
                return name.equals(this.pattern.getValue());
            }
            case 1: {
                return !name.equals(this.pattern.getValue());
            }
            case 2: {
                return name.indexOf(this.pattern.getValue()) >= 0;
            }
            case 3: {
                return name.indexOf(this.pattern.getValue()) < 0;
            }
            case 4: {
                return name.startsWith(this.pattern.getValue());
            }
            case 5: {
                return !name.startsWith(this.pattern.getValue());
            }
            case 6: {
                return name.endsWith(this.pattern.getValue());
            }
            case 7: {
                return !name.endsWith(this.pattern.getValue());
            }
            case 8: {
                return this.regexppattern.matcher(name).matches();
            }
            case 9: {
                return !this.regexppattern.matcher(name).matches();
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append("file path ");
        buff.append(allOperators[this.op]);
        buff.append(" '");
        buff.append(this.pattern.toString());
        buff.append('\'');
        return buff.toString();
    }
}

