/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.FilterRuleNotAppliableException;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.rules.filefilter.values.SizeValue;

public class FileSizeFileFilterRule
extends FileFilterRule {
    private static final long serialVersionUID = 2L;
    public static String typeName = "File size";
    public static final int OP_IS = 0;
    public static final int OP_ISNT = 1;
    public static final int OP_IS_GREATER_THAN = 2;
    public static final int OP_IS_LESS_THAN = 3;
    private static final String[] allOperators = new String[]{"is", "isn't", "is greater than", "is less than"};
    private SizeValue size;
    private int op;

    @Override
    public String getRuleType() {
        return typeName;
    }

    public static String[] getAllOperators() {
        return allOperators;
    }

    public static String[] getAllUnits() {
        return SizeValue.getAllUnits();
    }

    public FileSizeFileFilterRule(SizeValue size, int operator) {
        this.size = size;
        this.op = operator;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public String getOperatorName() {
        return allOperators[this.op];
    }

    @Override
    public OperandValue getValue() {
        return this.size;
    }

    @Override
    public boolean match(File file) throws FilterRuleNotAppliableException {
        long filesize = file.getSize();
        if (-1L == filesize) {
            throw new FilterRuleNotAppliableException("The file doesn't have any size attribute");
        }
        switch (this.op) {
            case 0: {
                return filesize == this.size.getBytes();
            }
            case 1: {
                return filesize != this.size.getBytes();
            }
            case 2: {
                return filesize > this.size.getBytes();
            }
            case 3: {
                return filesize < this.size.getBytes();
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append("file size ");
        buff.append(allOperators[this.op]);
        buff.append(" '");
        buff.append(this.size.toString());
        buff.append("'");
        return buff.toString();
    }
}

