/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter;

import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.rules.filefilter.values.TypeValue;

public class FileTypeFileFilterRule
extends FileFilterRule {
    private static final long serialVersionUID = 2L;
    public static String typeName = "File type";
    public static final int OP_IS = 0;
    public static final int OP_ISNT = 1;
    private static final String[] allOperators = new String[]{"is", "isn't"};
    private TypeValue type;
    private int op;

    @Override
    public String getRuleType() {
        return typeName;
    }

    public static String[] getAllOperators() {
        return allOperators;
    }

    public static String[] getAllOperands() {
        return TypeValue.getAllTypes();
    }

    public FileTypeFileFilterRule(TypeValue type, int operator) {
        this.type = type;
        this.op = operator;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public String getOperatorName() {
        return allOperators[this.op];
    }

    @Override
    public OperandValue getValue() {
        return this.type;
    }

    @Override
    public boolean match(File file) {
        switch (this.op) {
            case 0: {
                return this.type.isFile() && file.isFile() || this.type.isDirectory() && file.isDirectory();
            }
            case 1: {
                return !(this.type.isFile() && file.isFile() || this.type.isDirectory() && file.isDirectory());
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(30);
        buff.append("file type ");
        buff.append(allOperators[this.op]);
        buff.append(" '");
        buff.append(this.type.toString());
        buff.append('\'');
        return buff.toString();
    }
}

