/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter.filefiltertree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.StringTokenizer;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.filefiltertree.FileFilterTreeItem;

public class FileFilterTree
implements Serializable {
    private static final long serialVersionUID = 2L;
    private FileFilterTreeItem root = new FileFilterTreeItem();
    private HashMap<String, FileFilter> itemsMap = new HashMap();
    private String separator = "/";

    public void addFileFilter(String key, FileFilter filter) {
        StringTokenizer tokenizer = new StringTokenizer(key, this.separator);
        FileFilterTreeItem item = this.root;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            FileFilterTreeItem children = item.getChildren(token);
            if (children == null) {
                children = new FileFilterTreeItem();
            }
            item.addChildren(token, children);
            item = children;
        }
        item.setFilter(filter);
        this.itemsMap.put(key, filter);
    }

    public FileFilter getFilter(String key) {
        FileFilter filter = null;
        FileFilter parentFilter = null;
        StringTokenizer tokenizer = new StringTokenizer(key, this.separator);
        FileFilterTreeItem item = this.root;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            parentFilter = filter;
            FileFilterTreeItem children = item.getChildren(token);
            if (children == null) {
                return parentFilter;
            }
            FileFilter childFilter = children.getFilter();
            if (childFilter != null) {
                filter = childFilter;
            }
            item = children;
        }
        return parentFilter;
    }

    public HashMap<String, FileFilter> getItemsMap() {
        return this.itemsMap;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.root.toString());
        return buffer.toString();
    }
}

