/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter.values;

import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class AgeValue
implements OperandValue {
    private static final long serialVersionUID = 2L;
    private double value;
    private int unit;
    public static final int SECONDS = 0;
    public static final int MINUTES = 1;
    public static final int HOURS = 2;
    public static final int DAYS = 3;
    private static final String[] allUnits = new String[]{"seconds", "minutes", "hours", "days"};

    public static String[] getAllUnits() {
        return allUnits;
    }

    public AgeValue() {
        this.value = 0.0;
        this.unit = 0;
    }

    public AgeValue(String age) {
        this.fromString(age);
    }

    public AgeValue(double value, int unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public long getSeconds() {
        return (long)Math.floor(this.value * Math.pow(60.0, this.unit));
    }

    @Override
    public void fromString(String value) {
        int sep = value.indexOf(32);
        if (sep > 0) {
            this.value = Double.parseDouble(value.substring(0, sep));
            String u = value.substring(sep + 1, value.length());
            this.unit = this.getUnitFromString(u);
        }
    }

    public int getUnitFromString(String unitName) {
        for (int i = 0; i < allUnits.length; ++i) {
            if (!allUnits[i].equalsIgnoreCase(unitName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value) + " " + allUnits[this.unit];
    }
}

