/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter.values;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class DateValue
implements OperandValue {
    private static final long serialVersionUID = 2L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private long millis;

    public DateValue() {
        this.millis = 0L;
    }

    public DateValue(long millis) {
        this.millis = millis;
    }

    public DateValue(String date) {
        this.fromString(date);
    }

    public void setDate(Date date) {
        this.millis = date.getTime();
    }

    public Date getDate() {
        return new Date(this.millis);
    }

    public void setTime(long millis) {
        this.millis = millis;
    }

    public long getTime() {
        return this.millis;
    }

    @Override
    public void fromString(String value) {
        try {
            Date date = dateFormat.parse(value);
            this.millis = date.getTime();
        }
        catch (ParseException e) {
            this.millis = 0L;
        }
    }

    @Override
    public String toString() {
        return dateFormat.format(new Date(this.millis));
    }

    public boolean equals(long cmp) {
        Date compDate = new Date(cmp);
        Date date = new Date(this.millis);
        return date.getYear() == compDate.getYear() && date.getMonth() == compDate.getMonth() && date.getDay() == compDate.getDay();
    }

    public boolean isBefore(long cmp) {
        Date compDate = new Date(cmp);
        Date date = new Date(this.millis);
        if (date.getYear() < compDate.getYear()) {
            return true;
        }
        if (date.getYear() == compDate.getYear()) {
            if (date.getMonth() < compDate.getMonth()) {
                return true;
            }
            if (date.getMonth() == compDate.getMonth() && date.getDay() < compDate.getDay()) {
                return true;
            }
        }
        return false;
    }

    public boolean isAfter(long cmp) {
        Date compDate = new Date(cmp);
        Date date = new Date(this.millis);
        if (date.getYear() > compDate.getYear()) {
            return true;
        }
        if (date.getYear() == compDate.getYear()) {
            if (date.getMonth() > compDate.getMonth()) {
                return true;
            }
            if (date.getMonth() == compDate.getMonth() && date.getDay() > compDate.getDay()) {
                return true;
            }
        }
        return false;
    }
}

