/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter.values;

import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class SizeValue
implements OperandValue {
    private static final long serialVersionUID = 2L;
    private double value = 0.0;
    private int unit = 0;
    public static final int BYTES = 0;
    public static final int KILOBYTES = 1;
    public static final int MEGABYTES = 2;
    public static final int GIGABYTES = 3;
    private static final String[] allUnits = new String[]{"bytes", "KBytes", "MBytes", "GBytes"};

    public static String[] getAllUnits() {
        return allUnits;
    }

    public SizeValue() {
    }

    public SizeValue(String size) {
        this.fromString(size);
    }

    public long getBytes() {
        return (long)Math.floor(this.value * Math.pow(1024.0, this.unit));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setValue(String bytes) {
        try {
            this.value = Double.parseDouble(bytes);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    @Override
    public void fromString(String value) {
        int sep = value.indexOf(32);
        if (sep > 0) {
            this.value = Double.parseDouble(value.substring(0, sep));
            String u = value.substring(sep + 1, value.length());
            this.unit = this.getUnitFromString(u);
        }
    }

    private int getUnitFromString(String unitName) {
        for (int i = 0; i < allUnits.length; ++i) {
            if (!allUnits[i].equalsIgnoreCase(unitName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value) + " " + allUnits[this.unit];
    }
}

