/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.rules.filefilter.values;

import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;

public class TypeValue
implements OperandValue {
    private static final long serialVersionUID = 2L;
    public static final int FILE_TYPE = 0;
    public static final int DIRECTORY_TYPE = 1;
    private static final String[] valueNames = new String[]{"file", "directory"};
    private int type;

    public TypeValue() {
        this.type = 0;
    }

    public TypeValue(int type) {
        this.type = type;
    }

    public TypeValue(String type) {
        this.fromString(type);
    }

    public void setType(int fileType) {
        if (fileType < 0 || fileType > 1) {
            // empty if block
        }
        this.type = fileType;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void fromString(String str) {
        for (int i = 0; i < valueNames.length; ++i) {
            if (!valueNames[i].equalsIgnoreCase(str)) continue;
            this.type = i;
            return;
        }
    }

    @Override
    public String toString() {
        return valueNames[this.type];
    }

    public boolean isFile() {
        return this.type == 0;
    }

    public boolean isDirectory() {
        return this.type == 1;
    }

    public static String[] getAllTypes() {
        return valueNames;
    }
}

