/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.schedule;

import java.io.Serializable;
import java.util.StringTokenizer;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.ui.Messages;

public class CrontabPart
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final CrontabPart MINUTES = new CrontabPart("minutes", 0, 59, 0);
    public static final CrontabPart HOURS = new CrontabPart("hours", 0, 23, 0);
    public static final CrontabPart DAYSOFMONTH = new CrontabPart("daysOfMonth", 1, 31, 0);
    public static final CrontabPart MONTHS = new CrontabPart("months", 1, 12, -1);
    public static final CrontabPart DAYSOFWEEK = new CrontabPart("daysOfWeek", 0, 7, 1);
    public static final CrontabPart[] ALL_PARTS = new CrontabPart[]{MINUTES, HOURS, DAYSOFMONTH, MONTHS, DAYSOFWEEK};
    public final String name;
    public final int low;
    public final int offset;
    public final int high;

    public CrontabPart(String name, int low, int high, int offset) {
        this.name = name;
        this.low = low;
        this.high = high;
        this.offset = offset;
    }

    public Instance createInstance(String pattern) throws DataParseException {
        return new Instance(pattern);
    }

    public Instance createInstance(int[] intArray, int intOffset) {
        return new Instance(intArray, intOffset);
    }

    public class Instance
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final String pattern;
        public final boolean[] bArray;
        public final boolean all;

        public Instance(String pattern) throws DataParseException {
            this.pattern = pattern;
            this.bArray = new boolean[CrontabPart.this.high + 1 + CrontabPart.this.offset];
            this.all = this.parseToken(pattern);
        }

        public Instance(boolean[] bArray) {
            this.bArray = new boolean[CrontabPart.this.high + 1 + CrontabPart.this.offset];
            this.pattern = this.generatePattern();
            this.all = false;
        }

        public Instance(int[] intArray, int intOffset) {
            this.bArray = new boolean[CrontabPart.this.high + 1 + CrontabPart.this.offset];
            this.setIntArray(intArray, intOffset);
            this.pattern = this.generatePattern();
            this.all = false;
        }

        private void setIntArray(int[] intArray, int intOffset) {
            for (int i = 0; i < intArray.length; ++i) {
                this.bArray[intArray[i] - intOffset + CrontabPart.this.offset] = true;
            }
        }

        public int[] getIntArray(int intOffset) {
            int[] res;
            int[] a = new int[CrontabPart.this.high + 1];
            int aPos = 0;
            for (int i = CrontabPart.this.low; i <= CrontabPart.this.high; ++i) {
                if (!this.bArray[i + CrontabPart.this.offset]) continue;
                a[aPos++] = i + intOffset;
            }
            if (aPos == CrontabPart.this.high + 1) {
                res = a;
            } else {
                res = new int[aPos];
                for (int i = 0; i < aPos; ++i) {
                    res[i] = a[i];
                }
            }
            return res;
        }

        private String generatePattern() {
            StringBuffer p = new StringBuffer();
            for (int i = CrontabPart.this.low; i <= CrontabPart.this.high; ++i) {
                if (!this.bArray[i + CrontabPart.this.offset]) continue;
                p.append(String.valueOf(i)).append(',');
            }
            if (p.length() == 0) {
                return "0";
            }
            return p.substring(0, p.length() - 1);
        }

        private boolean parseToken(String token) throws DataParseException {
            int each = 1;
            try {
                int index = token.indexOf("/");
                if (index > 0) {
                    each = Integer.parseInt(token.substring(index + 1));
                    if (each == 0) {
                        throw new DataParseException(Messages.getString("CrontabPart.NeverUseExpressions"));
                    }
                    token = token.substring(0, index);
                }
                if (token.equals("*")) {
                    for (int i = CrontabPart.this.low; i < this.bArray.length - CrontabPart.this.offset; i += each) {
                        this.bArray[i + CrontabPart.this.offset] = true;
                    }
                    return each == 1;
                }
                index = token.indexOf(",");
                if (index > 0) {
                    StringTokenizer tokenizer = new StringTokenizer(token, ",");
                    while (tokenizer.hasMoreElements()) {
                        this.parseToken(tokenizer.nextToken());
                    }
                    return false;
                }
                index = token.indexOf("-");
                if (index > 0) {
                    int start = Integer.parseInt(token.substring(0, index));
                    int end = Integer.parseInt(token.substring(index + 1));
                    for (int j = start; j <= end; j += each) {
                        this.bArray[j + CrontabPart.this.offset] = true;
                    }
                    return false;
                }
                int iValue = Integer.parseInt(token);
                this.bArray[iValue + CrontabPart.this.offset] = true;
                return false;
            }
            catch (Exception e) {
                throw new DataParseException(Messages.getString("CrontabPart.SomethingWasWrong") + token, e);
            }
        }
    }
}

