/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.schedule;

import java.util.Calendar;
import java.util.StringTokenizer;
import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.schedule.CrontabPart;
import net.sourceforge.fullsync.schedule.Schedule;
import org.w3c.dom.Element;

public class CrontabSchedule
extends Schedule {
    public static final String SCHEDULE_TYPE = "crontab";
    private static final long serialVersionUID = 2L;
    private String origPattern;
    private CrontabPart.Instance minutes;
    private CrontabPart.Instance hours;
    private CrontabPart.Instance daysOfMonth;
    private CrontabPart.Instance months;
    private CrontabPart.Instance daysOfWeek;
    private transient long lastExecution;

    public CrontabSchedule(Element element) throws DataParseException {
        String pattern = "* * * * *";
        if (element.hasAttribute("pattern")) {
            pattern = element.getAttribute("pattern");
        }
        this.read(pattern);
    }

    @Override
    public Element serialize(Element element) {
        element.setAttribute("type", SCHEDULE_TYPE);
        element.setAttribute("pattern", this.getPattern());
        return element;
    }

    public CrontabSchedule() throws DataParseException {
        this.read("* * * * *");
    }

    public CrontabSchedule(String pattern) throws DataParseException {
        this.read(pattern);
        if (this.daysOfWeek.bArray[8]) {
            this.daysOfWeek.bArray[1] = true;
        }
    }

    public CrontabSchedule(CrontabPart.Instance minutes, CrontabPart.Instance hours, CrontabPart.Instance daysOfMonth, CrontabPart.Instance months, CrontabPart.Instance daysOfWeek) {
        this.minutes = minutes;
        this.hours = hours;
        this.daysOfMonth = daysOfMonth;
        this.months = months;
        this.daysOfWeek = daysOfWeek;
        if (daysOfWeek.bArray[8]) {
            daysOfWeek.bArray[1] = true;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(minutes.pattern).append(' ');
        buff.append(hours.pattern).append(' ');
        buff.append(daysOfMonth.pattern).append(' ');
        buff.append(months.pattern).append(' ');
        buff.append(daysOfWeek.pattern);
        this.origPattern = buff.toString();
    }

    private void read(String pattern) throws DataParseException {
        this.origPattern = pattern;
        StringTokenizer tokenizer = new StringTokenizer(pattern);
        this.minutes = CrontabPart.MINUTES.createInstance(tokenizer.nextToken());
        this.hours = CrontabPart.HOURS.createInstance(tokenizer.nextToken());
        this.daysOfMonth = CrontabPart.DAYSOFMONTH.createInstance(tokenizer.nextToken());
        this.months = CrontabPart.MONTHS.createInstance(tokenizer.nextToken());
        this.daysOfWeek = CrontabPart.DAYSOFWEEK.createInstance(tokenizer.nextToken());
    }

    public String getPattern() {
        return this.origPattern;
    }

    @Override
    public long getNextOccurrence(long now) {
        if (now == this.lastExecution) {
            now += 1000L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(now);
        this.gotoNextOrStay(this.months.bArray, cal, 2);
        if (this.months.all && this.daysOfMonth.all && !this.daysOfWeek.all) {
            this.gotoNextOrStay(this.daysOfWeek.bArray, cal, 7);
        } else {
            this.gotoNextOrStay(this.daysOfMonth.bArray, cal, 5);
        }
        this.gotoNextOrStay(this.hours.bArray, cal, 11);
        this.gotoNextOrStay(this.minutes.bArray, cal, 12);
        if (cal.get(13) != 0 || cal.get(14) != 0) {
            cal.set(13, 0);
            cal.set(14, 0);
            this.gotoNext(this.minutes.bArray, cal, 12);
        }
        return cal.getTimeInMillis();
    }

    private void gotoNextOrStay(boolean[] bArray, Calendar cal, int field) {
        if (!bArray[cal.get(field)]) {
            this.gotoNext(bArray, cal, field);
        }
    }

    private void gotoNext(boolean[] bArray, Calendar cal, int field) {
        int orig = cal.get(field);
        int now = orig + 1;
        int max = cal.getActualMaximum(field);
        int min = cal.getActualMinimum(field);
        while (now > max || !bArray[now]) {
            if (++now <= max) continue;
            switch (field) {
                case 2: {
                    cal.add(1, 1);
                    break;
                }
                case 5: {
                    this.gotoNext(this.months.bArray, cal, 2);
                    break;
                }
                case 7: {
                    cal.add(5, now - orig);
                    orig = now;
                    break;
                }
                case 11: {
                    if (this.months.all && this.daysOfMonth.all && !this.daysOfWeek.all) {
                        this.gotoNext(this.daysOfWeek.bArray, cal, 7);
                        break;
                    }
                    if (!this.daysOfMonth.all) {
                        this.gotoNext(this.daysOfMonth.bArray, cal, 5);
                        break;
                    }
                    this.gotoNext(this.daysOfMonth.bArray, cal, 5);
                    break;
                }
                case 12: {
                    this.gotoNext(this.hours.bArray, cal, 11);
                }
            }
            now = min;
        }
        if (now != orig) {
            switch (field) {
                case 2: {
                    cal.set(5, 1);
                }
                case 5: 
                case 7: {
                    cal.set(11, 0);
                }
                case 11: {
                    cal.set(12, 0);
                }
                case 12: {
                    cal.set(13, 0);
                    cal.set(14, 0);
                }
            }
        }
        cal.set(field, now);
    }

    @Override
    public void setLastOccurrence(long now) {
        this.lastExecution = now;
    }

    public CrontabPart.Instance[] getParts() {
        return new CrontabPart.Instance[]{this.minutes, this.hours, this.daysOfMonth, this.months, this.daysOfWeek};
    }

    public String toString() {
        return "Crontab: " + this.origPattern;
    }
}

