/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.schedule;

import net.sourceforge.fullsync.schedule.Schedule;
import org.w3c.dom.Element;

public class IntervalSchedule
extends Schedule {
    public static final String SCHEDULE_TYPE = "interval";
    private static final long serialVersionUID = 2L;
    long firstInterval;
    long interval;
    long next;
    String displayUnit;

    public IntervalSchedule(Element element) {
        if (element.hasAttribute("firstinterval")) {
            this.firstInterval = Long.parseLong(element.getAttribute("firstinterval"));
        }
        if (element.hasAttribute(SCHEDULE_TYPE)) {
            this.interval = Long.parseLong(element.getAttribute(SCHEDULE_TYPE));
        }
        if (element.hasAttribute("displayUnit")) {
            this.displayUnit = element.getAttribute("displayUnit");
        }
        this.next = System.currentTimeMillis() + this.firstInterval;
    }

    public IntervalSchedule(long firstInterval, long interval, String displayUnit) {
        this.firstInterval = firstInterval;
        this.interval = interval;
        this.displayUnit = displayUnit;
        this.next = System.currentTimeMillis() + firstInterval;
    }

    @Override
    public final Element serialize(Element element) {
        element.setAttribute("type", SCHEDULE_TYPE);
        element.setAttribute("firstinterval", "" + this.firstInterval);
        element.setAttribute(SCHEDULE_TYPE, "" + this.interval);
        element.setAttribute("displayUnit", this.displayUnit);
        return element;
    }

    @Override
    public long getNextOccurrence(long now) {
        return this.next > now ? this.next : now;
    }

    @Override
    public void setLastOccurrence(long now) {
        this.next = now + this.interval;
    }

    public long getFirstInterval() {
        return this.firstInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public String getIntervalDisplayUnit() {
        return this.displayUnit;
    }
}

