/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.schedule;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.schedule.CrontabSchedule;
import net.sourceforge.fullsync.schedule.IntervalSchedule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Schedule
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String ELEMENT_NAME = "Schedule";
    private static final Hashtable<String, Class<? extends Schedule>> scheduleRegister = new Hashtable(2);

    public abstract long getNextOccurrence(long var1);

    public abstract void setLastOccurrence(long var1);

    public abstract Element serialize(Element var1);

    public static final Schedule unserialize(Element element) {
        if (element == null) {
            return null;
        }
        String scheduleType = element.getAttribute("type");
        Class<? extends Schedule> scheduleClass = scheduleRegister.get(scheduleType);
        if (scheduleClass == null) {
            return null;
        }
        Schedule sched = null;
        try {
            Constructor<? extends Schedule> constructor = scheduleClass.getDeclaredConstructor(Element.class);
            sched = constructor.newInstance(element);
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
        return sched;
    }

    public static final Element serialize(Schedule sch, Document doc) {
        Element element = doc.createElement(ELEMENT_NAME);
        return sch.serialize(element);
    }

    static {
        scheduleRegister.put("interval", IntervalSchedule.class);
        scheduleRegister.put("crontab", CrontabSchedule.class);
    }
}

