/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.schedule;

import java.util.ArrayList;
import net.sourceforge.fullsync.schedule.ScheduleTask;
import net.sourceforge.fullsync.schedule.ScheduleTaskSource;
import net.sourceforge.fullsync.schedule.Scheduler;
import net.sourceforge.fullsync.schedule.SchedulerChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerImpl
implements Scheduler,
Runnable {
    private Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private ScheduleTaskSource scheduleSource;
    private Thread worker;
    private boolean running;
    private boolean enabled;
    private ArrayList<SchedulerChangeListener> schedulerListeners;

    public SchedulerImpl() {
        this(null);
    }

    public SchedulerImpl(ScheduleTaskSource source) {
        this.scheduleSource = source;
        this.schedulerListeners = new ArrayList();
    }

    @Override
    public void setSource(ScheduleTaskSource source) {
        this.scheduleSource = source;
    }

    @Override
    public ScheduleTaskSource getSource() {
        return this.scheduleSource;
    }

    @Override
    public void addSchedulerChangeListener(SchedulerChangeListener listener) {
        this.schedulerListeners.add(listener);
    }

    @Override
    public void removeSchedulerChangeListener(SchedulerChangeListener listener) {
        this.schedulerListeners.remove(listener);
    }

    protected void fireSchedulerChangedEvent() {
        for (int i = 0; i < this.schedulerListeners.size(); ++i) {
            this.schedulerListeners.get(i).schedulerStatusChanged(this.enabled);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void start() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.worker == null || !this.worker.isAlive()) {
            this.worker = new Thread((Runnable)this, "Scheduler");
            this.worker.setDaemon(true);
            this.worker.start();
        }
        this.fireSchedulerChangedEvent();
    }

    @Override
    public void stop() {
        if (!this.enabled || this.worker == null) {
            return;
        }
        this.enabled = false;
        if (this.running) {
            this.worker.interrupt();
        }
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.worker = null;
        }
        this.fireSchedulerChangedEvent();
    }

    @Override
    public void refresh() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    @Override
    public void run() {
        this.running = true;
        while (this.enabled) {
            ScheduleTask task;
            long now = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("searching for next task after " + now);
            }
            if ((task = this.scheduleSource.getNextScheduleTask()) == null) {
                this.logger.info("could not find a scheduled task, aborting");
                break;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("found: " + task.toString() + " at " + task.getExecutionTime());
            }
            long nextTime = task.getExecutionTime();
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("waiting for " + (nextTime - now) + " mseconds");
                }
                if (nextTime >= now) {
                    Thread.sleep(nextTime - now);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Running task " + task);
                }
                task.run();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.running = false;
        if (this.enabled) {
            this.enabled = false;
            this.fireSchedulerChangedEvent();
        }
    }
}

