/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.ui.AsyncUIUpdate;
import net.sourceforge.fullsync.ui.ChangeLogBox;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.LogoHeaderComposite;
import net.sourceforge.fullsync.ui.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

class AboutDialog
extends Dialog
implements DisposeListener,
AsyncUIUpdate {
    private static final String FULLSYNC_LICENSES_DIRECTORY = "net/sourceforge/fullsync/licenses/";
    private static final long delay = 750L;
    private int stIndex = 0;
    private Timer stTimer;
    private Combo componentCombo;
    StyledText licenseText;
    private List<String> licenseNames;
    private List<String> licenseTexts;

    AboutDialog(final Shell parent, int style) {
        super(parent, style);
        try {
            final Shell dialogShell = new Shell(parent, 67696);
            dialogShell.addDisposeListener((DisposeListener)this);
            GridLayout dialogShellLayout = new GridLayout(1, true);
            dialogShellLayout.marginTop = 0;
            dialogShellLayout.marginHeight = 0;
            dialogShellLayout.marginWidth = 0;
            dialogShellLayout.marginBottom = 5;
            dialogShellLayout.verticalSpacing = 5;
            dialogShellLayout.horizontalSpacing = 5;
            dialogShell.setLayout((Layout)dialogShellLayout);
            dialogShell.setText(Messages.getString("AboutDialog.About_FullSync"));
            LogoHeaderComposite logoComposite = new LogoHeaderComposite((Composite)dialogShell, 4);
            GridData logoCompositeLData = new GridData();
            logoCompositeLData.grabExcessHorizontalSpace = true;
            logoCompositeLData.horizontalAlignment = 4;
            logoComposite.setLayoutData(logoCompositeLData);
            final TabFolder tabs = new TabFolder((Composite)dialogShell, 4);
            GridData tabLData = new GridData(1808);
            tabs.setLayout((Layout)new FillLayout());
            final TabItem tabGeneral = new TabItem(tabs, 0);
            tabGeneral.setText(Messages.getString("AboutDialog.Tab_About"));
            tabGeneral.setControl((Control)this.initAboutTab((Composite)tabs));
            dialogShell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Point generalTabSize = tabGeneral.getControl().computeSize(-1, -1);
                    Rectangle tabsClientSize = tabs.getClientArea();
                    int width = generalTabSize.x - tabsClientSize.width;
                    int height = generalTabSize.y - tabsClientSize.height;
                    Point dlgSize = dialogShell.getSize();
                    width = dlgSize.x + width;
                    height = dlgSize.y + height;
                    dialogShell.setSize(width, height);
                    Rectangle parentBounds = parent.getBounds();
                    dialogShell.setLocation(parentBounds.x + parentBounds.width / 2 - width / 2, parentBounds.y + parentBounds.height / 2 - height / 2);
                }
            });
            TabItem tabLicenses = new TabItem(tabs, 0);
            tabLicenses.setText(Messages.getString("AboutDialog.Tab_Licenses"));
            tabLicenses.setControl((Control)this.initLicensesTab((Composite)tabs));
            TabItem tabChangelog = new TabItem(tabs, 0);
            tabChangelog.setText(Messages.getString("AboutDialog.Tab_Changelog"));
            tabChangelog.setControl(this.initChangelogTab((Composite)tabs));
            tabs.setLayoutData((Object)tabLData);
            Button buttonOk = new Button((Composite)dialogShell, 0x1000008);
            buttonOk.setText(Messages.getString("AboutDialog.Ok"));
            buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    dialogShell.close();
                }
            });
            GridData buttonOkLData = new GridData();
            buttonOkLData.horizontalAlignment = 2;
            buttonOkLData.heightHint = 25;
            buttonOkLData.widthHint = 100;
            buttonOkLData.grabExcessHorizontalSpace = true;
            buttonOk.setLayoutData((Object)buttonOkLData);
            dialogShell.layout(true);
            dialogShell.open();
            buttonOk.setFocus();
            Display display = dialogShell.getDisplay();
            while (!dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    private Control initChangelogTab(Composite parent) {
        Composite tab = new Composite(parent, 4);
        tab.setLayout((Layout)new GridLayout(1, true));
        ChangeLogBox changeLogBox = new ChangeLogBox(tab, 0, "");
        GridData changelogBoxLData = new GridData(1808);
        changelogBoxLData.heightHint = 300;
        changeLogBox.setLayoutData(changelogBoxLData);
        return tab;
    }

    public final void widgetDisposed(DisposeEvent e) {
        if (this.stTimer != null) {
            this.stTimer.cancel();
        }
    }

    private Composite initAboutTab(Composite parent) {
        String[] specialThanks;
        final Composite tab = new Composite(parent, 4);
        tab.setLayout((Layout)new GridLayout(1, true));
        String version = Util.getFullSyncVersion();
        Label labelVersion = new Label(tab, 4);
        labelVersion.setText(Messages.getString("AboutDialog.Version", version));
        GridData lvd = new GridData(4);
        lvd.grabExcessHorizontalSpace = true;
        labelVersion.setLayoutData((Object)lvd);
        Link copyright = new Link(tab, 4);
        String copyrightText = Util.getResourceAsString("net/sourceforge/fullsync/copyright.txt");
        copyrightText = copyrightText.replaceAll("\\{version\\}", version);
        copyright.setText(copyrightText);
        GridData lcd = new GridData(4);
        lcd.grabExcessHorizontalSpace = true;
        copyright.setLayoutData((Object)lcd);
        copyright.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GuiController.launchProgram(evt.text);
            }
        });
        Label labelSeparator1 = new Label(tab, 258);
        GridData labelSeparatorLData = new GridData();
        labelSeparatorLData.horizontalAlignment = 4;
        labelSeparatorLData.grabExcessHorizontalSpace = true;
        labelSeparator1.setLayoutData((Object)labelSeparatorLData);
        final Label labelThanks = new Label(tab, 0x1000000);
        GridData labelThanksLData = new GridData();
        labelThanksLData.grabExcessHorizontalSpace = true;
        labelThanksLData.horizontalAlignment = 2;
        labelThanks.setLayoutData((Object)labelThanksLData);
        labelThanks.setText("\n\n\n");
        labelThanks.setAlignment(0x1000000);
        this.stTimer = new Timer(false);
        String sp = Util.getResourceAsString("net/sourceforge/fullsync/special-thanks.txt");
        String[] res = sp.split("\n");
        if (null != res) {
            specialThanks = res;
        } else {
            sp = "";
            specialThanks = new String[]{sp, sp, sp};
        }
        this.stTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Display display = Display.getDefault();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!labelThanks.isDisposed()) {
                            int firstLine = AboutDialog.this.stIndex % specialThanks.length;
                            int secondLine = (AboutDialog.this.stIndex + 1) % specialThanks.length;
                            int thirdLine = (AboutDialog.this.stIndex + 2) % specialThanks.length;
                            labelThanks.setText(specialThanks[firstLine] + '\n' + specialThanks[secondLine] + '\n' + specialThanks[thirdLine]);
                            labelThanks.pack(true);
                            tab.layout(new Control[]{labelThanks});
                            AboutDialog.this.stIndex++;
                            AboutDialog.this.stIndex = AboutDialog.this.stIndex % specialThanks.length;
                        }
                    }
                });
            }
        }, 750L, 750L);
        Label labelSeparator2 = new Label(tab, 258);
        GridData labelSeparator2LData = new GridData();
        labelSeparator2LData.grabExcessHorizontalSpace = true;
        labelSeparator2LData.horizontalAlignment = 4;
        labelSeparator2.setLayoutData((Object)labelSeparator2LData);
        Composite compositeBottom = new Composite(tab, 0);
        GridLayout compositeBottomLayout = new GridLayout();
        GridData compositeBottomLData = new GridData();
        compositeBottomLData.horizontalAlignment = 4;
        compositeBottom.setLayoutData((Object)compositeBottomLData);
        compositeBottomLayout.makeColumnsEqualWidth = true;
        compositeBottomLayout.numColumns = 2;
        compositeBottom.setLayout((Layout)compositeBottomLayout);
        Link websiteLink = new Link(compositeBottom, 0);
        websiteLink.setText(String.format("<a>%s</a>", Messages.getString("AboutDialog.WebSite")));
        GridData websiteLinkLData = new GridData();
        websiteLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GuiController.launchProgram(Util.getWebsiteURL());
            }
        });
        websiteLinkLData.grabExcessHorizontalSpace = false;
        websiteLinkLData.horizontalAlignment = 0x1000000;
        websiteLink.setLayoutData((Object)websiteLinkLData);
        Composite compositeTwitter = new Composite(compositeBottom, 0);
        compositeTwitter.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        compositeTwitter.setLayout((Layout)new GridLayout(2, false));
        Image twitterBird = GuiController.getInstance().getImage("twitter_bird_blue_16.png");
        Label twitterBirdLabel = new Label(compositeTwitter, 0);
        Rectangle twitterBirdBounds = twitterBird.getBounds();
        twitterBirdLabel.setSize(twitterBirdBounds.width, twitterBirdBounds.height);
        twitterBirdLabel.setImage(twitterBird);
        Link twitterLink = new Link(compositeTwitter, 0);
        twitterLink.setText("<a>@FullSyncNews</a>");
        GridData twitterLinkLData = new GridData();
        twitterLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                GuiController.launchProgram(Util.getTwitterURL());
            }
        });
        twitterLink.setLayoutData((Object)twitterLinkLData);
        tab.pack();
        tab.layout();
        return tab;
    }

    private Composite initLicensesTab(Composite parent) throws IOException {
        Composite tab = new Composite(parent, 4);
        tab.setLayout((Layout)new GridLayout(2, false));
        Label component = new Label(tab, 0);
        component.setText(Messages.getString("AboutDialog.Component"));
        this.componentCombo = new Combo(tab, 12);
        GridData componentComboLData = new GridData(4, 0, true, false);
        this.componentCombo.setLayoutData((Object)componentComboLData);
        this.licenseText = new StyledText(tab, 2824);
        this.licenseText.setAlwaysShowScrollBars(false);
        GridData licenseTextLData = new GridData(1808);
        licenseTextLData.horizontalSpan = 2;
        this.licenseText.setLayoutData((Object)licenseTextLData);
        this.componentCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (null != AboutDialog.this.licenseTexts) {
                    int index = AboutDialog.this.componentCombo.getSelectionIndex();
                    AboutDialog.this.licenseText.setText((String)AboutDialog.this.licenseTexts.get(index));
                }
            }
        });
        GuiController.backgroundExec(this);
        return tab;
    }

    @Override
    public void execute() throws Throwable {
        int numLicenses = 0;
        ArrayList<LicenseEntry> licenses = new ArrayList<LicenseEntry>();
        for (String name : Util.loadDirectoryFromClasspath(AboutDialog.class, FULLSYNC_LICENSES_DIRECTORY)) {
            if (!name.endsWith(".txt")) continue;
            ++numLicenses;
            LicenseEntry entry = new LicenseEntry();
            entry.name = name.substring(0, name.length() - 4);
            entry.license = Util.getResourceAsString(FULLSYNC_LICENSES_DIRECTORY + name);
            licenses.add(entry);
        }
        Collections.sort(licenses, new Comparator<LicenseEntry>(){

            @Override
            public int compare(LicenseEntry o1, LicenseEntry o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        this.licenseNames = new ArrayList<String>(numLicenses);
        this.licenseTexts = new ArrayList<String>(numLicenses);
        for (LicenseEntry lic : licenses) {
            this.licenseNames.add(lic.name);
            this.licenseTexts.add(lic.license);
        }
    }

    @Override
    public void updateUI(boolean succeeded) {
        int idx = 0;
        int fsIdx = 0;
        for (String licenseName : this.licenseNames) {
            this.componentCombo.add(licenseName);
            if ("FullSync".equals(licenseName)) {
                fsIdx = idx;
            }
            ++idx;
        }
        this.licenseNames = null;
        this.componentCombo.select(fsIdx);
        this.licenseText.setText(this.licenseTexts.get(fsIdx));
    }

    private static class LicenseEntry {
        public String name;
        public String license;

        private LicenseEntry() {
        }
    }
}

