/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.File;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.changelog.ChangeLogEntry;
import net.sourceforge.fullsync.changelog.ChangeLogLoader;
import net.sourceforge.fullsync.ui.AsyncUIUpdate;
import net.sourceforge.fullsync.ui.GuiController;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class ChangeLogBox
extends StyledText
implements AsyncUIUpdate {
    private String lastFullSyncVersion;
    private List<ChangeLogEntry> changelog;

    public ChangeLogBox(Composite parent, int style, String _lastFullSyncVersion) {
        super(parent, style | 0x800 | 8 | 0x200 | 0x100);
        this.setAlwaysShowScrollBars(false);
        this.lastFullSyncVersion = _lastFullSyncVersion;
        GuiController.backgroundExec(this);
    }

    @Override
    public void execute() throws Throwable {
        ChangeLogLoader loader = new ChangeLogLoader();
        this.changelog = ChangeLogLoader.filterAfter(loader.load(new File(Util.getInstalllocation(), "versions"), ".+\\.html"), this.lastFullSyncVersion);
    }

    @Override
    public void updateUI(boolean succeeded) {
        if (!this.isDisposed()) {
            if (succeeded) {
                StringWriter sw = new StringWriter();
                DateFormat dateFormat = SimpleDateFormat.getDateInstance(2, Locale.getDefault());
                for (ChangeLogEntry entry : this.changelog) {
                    entry.write("FullSync %s released on %s", " - %s", sw, dateFormat);
                }
                sw.flush();
                this.setText(sw.toString());
            } else {
                this.setText("Failed to load Changelogs.");
            }
        }
    }
}

