/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.FTPSpecificComposite;
import net.sourceforge.fullsync.ui.FileSpecificComposite;
import net.sourceforge.fullsync.ui.ProtocolSpecificComposite;
import net.sourceforge.fullsync.ui.SFTPSpecificComposite;
import net.sourceforge.fullsync.ui.SMBSpecificComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConnectionConfiguration
implements ModifyListener {
    private Composite m_parent;
    private static String[] schemes = new String[]{"file", "ftp", "sftp", "smb"};
    private static HashMap<String, Class<? extends ProtocolSpecificComposite>> composites = new HashMap();
    private Label labelProtocol = null;
    private Combo comboProtocol = null;
    private Composite compositeProtocolSpecific = null;
    private ProtocolSpecificComposite compositeSpecific;
    private String selectedScheme;
    private boolean bufferedEnabled = true;
    private boolean bufferedActive = false;

    public ConnectionConfiguration(Composite parent, ConnectionDescription desc) {
        URI uri;
        this.m_parent = parent;
        if (null != desc && null != (uri = desc.getUri())) {
            this.selectedScheme = uri.getScheme();
        }
        this.initialize();
    }

    private void initialize() {
        this.compositeProtocolSpecific = new Composite(this.m_parent, 0);
        this.compositeProtocolSpecific.setLayout((Layout)new GridLayout(3, false));
        this.compositeProtocolSpecific.setLayoutData((Object)new GridData(4, 4, true, true));
        this.labelProtocol = new Label(this.compositeProtocolSpecific, 0);
        this.labelProtocol.setText("Protocol:");
        this.comboProtocol = new Combo(this.compositeProtocolSpecific, 8);
        GridData protocolData = new GridData();
        protocolData.horizontalSpan = 2;
        protocolData.horizontalAlignment = 4;
        this.comboProtocol.setLayoutData((Object)protocolData);
        this.comboProtocol.removeAll();
        int selectedIndex = 0;
        int i = 0;
        for (String scheme : schemes) {
            this.comboProtocol.add(scheme);
            if (scheme.equals(this.selectedScheme)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.comboProtocol.select(selectedIndex);
        this.comboProtocol.addModifyListener((ModifyListener)this);
        this.selectedScheme = this.comboProtocol.getText();
        this.createProtocolSpecificComposite();
    }

    public void modifyText(ModifyEvent e) {
        this.selectedScheme = this.comboProtocol.getText();
        this.m_parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (Control c : ConnectionConfiguration.this.m_parent.getChildren()) {
                    if (c.isDisposed()) continue;
                    c.dispose();
                }
                ConnectionConfiguration.this.initialize();
                ConnectionConfiguration.this.m_parent.layout(true);
            }
        });
    }

    public void setConnectionDescription(ConnectionDescription location) {
        this.compositeSpecific.setConnectionDescription(location);
    }

    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        return this.compositeSpecific.getConnectionDescription();
    }

    private void createProtocolSpecificComposite() {
        Class<? extends ProtocolSpecificComposite> com = composites.get(this.selectedScheme);
        try {
            this.compositeSpecific = com.newInstance();
            this.compositeSpecific.createGUI(this.compositeProtocolSpecific);
            this.compositeSpecific.reset(this.selectedScheme);
            this.compositeSpecific.setBufferedEnabled(this.bufferedEnabled);
            this.compositeSpecific.setBuffered(this.bufferedActive);
        }
        catch (InstantiationException e) {
            ExceptionHandler.reportException(e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.reportException(e);
            e.printStackTrace();
        }
    }

    public boolean getBuffered() {
        return this.compositeSpecific.getBuffered();
    }

    public void setBuffered(boolean buffered) {
        this.bufferedActive = buffered;
        this.compositeSpecific.setBuffered(buffered);
    }

    public void setBufferedEnabled(boolean enabled) {
        this.bufferedEnabled = enabled;
        this.compositeSpecific.setBufferedEnabled(enabled);
    }

    static {
        composites.put("file", FileSpecificComposite.class);
        composites.put("ftp", FTPSpecificComposite.class);
        composites.put("sftp", SFTPSpecificComposite.class);
        composites.put("smb", SMBSpecificComposite.class);
    }
}

