/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.remote.RemoteManager;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class ConnectionPage
extends WizardDialog {
    private Text textFieldHostname;
    private Text textFieldPort;
    private Text textPassword;
    private Button cbDisableRemoteListener;

    public ConnectionPage(Shell parent) {
        super(parent);
    }

    @Override
    public String getTitle() {
        return Messages.getString("ConnectionPage.Connection");
    }

    @Override
    public String getCaption() {
        return Messages.getString("ConnectionPage.ConnectToARemoteServer");
    }

    @Override
    public String getDescription() {
        return Messages.getString("ConnectionPage.ChooseTarget");
    }

    @Override
    public Image getIcon() {
        return GuiController.getInstance().getImage("Remote_Connect.png");
    }

    @Override
    public Image getImage() {
        return GuiController.getInstance().getImage("Remote_Wizard.png");
    }

    @Override
    public void createContent(Composite content) {
        GridLayout thisLayout = new GridLayout(2, false);
        content.setLayout((Layout)thisLayout);
        GridData gdata = new GridData();
        gdata.grabExcessHorizontalSpace = true;
        gdata.horizontalAlignment = 4;
        content.setLayoutData((Object)gdata);
        Label labelHostname = new Label(content, 0);
        labelHostname.setText(Messages.getString("ConnectionComposite.Hostname") + ":");
        this.textFieldHostname = new Text(content, 2048);
        this.textFieldHostname.setText("localhost");
        GridData textFieldHostnameLData = new GridData();
        textFieldHostnameLData.horizontalAlignment = 4;
        textFieldHostnameLData.grabExcessHorizontalSpace = true;
        this.textFieldHostname.setLayoutData((Object)textFieldHostnameLData);
        Label labelPort = new Label(content, 0);
        labelPort.setText(Messages.getString("ConnectionComposite.Port") + ":");
        this.textFieldPort = new Text(content, 2048);
        this.textFieldPort.setText("10000");
        GridData textFieldPortLData = new GridData();
        textFieldPortLData.horizontalAlignment = 4;
        textFieldPortLData.grabExcessHorizontalSpace = true;
        this.textFieldPort.setLayoutData((Object)textFieldPortLData);
        Label labelPassword = new Label(content, 0);
        labelPassword.setText(Messages.getString("ConnectionComposite.Password") + ":");
        this.textPassword = new Text(content, 2048);
        GridData textPasswordLData = new GridData();
        textPasswordLData.horizontalAlignment = 4;
        textPasswordLData.grabExcessHorizontalSpace = true;
        this.textPassword.setLayoutData((Object)textPasswordLData);
        this.textPassword.setEchoChar('*');
        this.cbDisableRemoteListener = new Button(content, 16416);
        this.cbDisableRemoteListener.setText(Messages.getString("ConnectionComposite.Disable_Indicator"));
        GridData cbDisableRemoteListenerLData = new GridData();
        cbDisableRemoteListenerLData.horizontalSpan = 2;
        this.cbDisableRemoteListener.setLayoutData((Object)cbDisableRemoteListenerLData);
        content.layout();
    }

    @Override
    public boolean apply() {
        String hostname = this.textFieldHostname.getText();
        int port = 0;
        try {
            port = Integer.parseInt(this.textFieldPort.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String password = this.textPassword.getText();
        boolean useRemoteListener = !this.cbDisableRemoteListener.getSelection();
        try {
            GuiController.getInstance().getProfileManager().setRemoteConnected(true);
            GuiController.getInstance().getProfileManager().stopScheduler();
            RemoteManager remoteManager = new RemoteManager(hostname, port, password);
            if (remoteManager.isConnectedToRemoteInstance()) {
                throw new Exception("The FullSync instance you tried to connect to is already connected to another FullSync instance");
            }
            remoteManager.setUseRemoteListener(useRemoteListener);
            GuiController.getInstance().getProfileManager().setRemoteConnection(remoteManager);
            GuiController.getInstance().getSynchronizer().setRemoteConnection(remoteManager);
        }
        catch (Exception e1) {
            GuiController.getInstance().getProfileManager().setRemoteConnected(false);
            ExceptionHandler.reportException(Messages.getString("ConnectionComposite.Unable_To_Connect"), e1);
        }
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

