/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.DataParseException;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.schedule.CrontabPart;
import net.sourceforge.fullsync.schedule.CrontabSchedule;
import net.sourceforge.fullsync.schedule.Schedule;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ScheduleOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class CrontabScheduleOptions
extends ScheduleOptions {
    private PartContainer[] parts;

    public CrontabScheduleOptions(Composite parent, int style) {
        super(parent, style);
        try {
            this.setLayout((Layout)new GridLayout(4, false));
            CrontabPart[] cronParts = CrontabPart.ALL_PARTS;
            this.parts = new PartContainer[cronParts.length];
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i] = new PartContainer(cronParts[i]);
            }
            this.layout();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public String getSchedulingName() {
        return Messages.getString("CrontabScheduleOptions.Crontab");
    }

    @Override
    public boolean canHandleSchedule(Schedule schedule) {
        return schedule instanceof CrontabSchedule;
    }

    @Override
    public void setSchedule(Schedule schedule) {
        if (schedule instanceof CrontabSchedule) {
            CrontabPart.Instance[] instances = ((CrontabSchedule)schedule).getParts();
            for (int i = 0; i < instances.length; ++i) {
                this.parts[i].setInstance(instances[i]);
            }
        }
    }

    @Override
    public Schedule getSchedule() throws DataParseException {
        return new CrontabSchedule(this.parts[0].getInstance(), this.parts[1].getInstance(), this.parts[2].getInstance(), this.parts[3].getInstance(), this.parts[4].getInstance());
    }

    class PartContainer {
        private CrontabPart part;
        private Button cbAll;
        private Text text;
        private Button buttonChoose;

        public PartContainer(CrontabPart crontabPart) {
            this.part = crontabPart;
            Label label = new Label((Composite)CrontabScheduleOptions.this, 0);
            label.setText(this.part.name);
            this.cbAll = new Button((Composite)CrontabScheduleOptions.this, 32);
            this.cbAll.setText(Messages.getString("CrontabScheduleOptions.all"));
            this.cbAll.setSelection(true);
            this.cbAll.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PartContainer.this.text.setEnabled(!PartContainer.this.cbAll.getSelection());
                    PartContainer.this.buttonChoose.setEnabled(!PartContainer.this.cbAll.getSelection());
                }
            });
            this.text = new Text((Composite)CrontabScheduleOptions.this, 2048);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.text.setText("*");
            this.text.setEnabled(false);
            this.buttonChoose = new Button((Composite)CrontabScheduleOptions.this, 0);
            this.buttonChoose.setText("...");
            this.buttonChoose.setEnabled(false);
            this.buttonChoose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    final Shell shell = new Shell(CrontabScheduleOptions.this.getShell(), 67684);
                    shell.setLayout((Layout)new GridLayout(2, false));
                    shell.setText(Messages.getString("CrontabScheduleOptions.Select") + ((PartContainer)PartContainer.this).part.name);
                    final List table = new List((Composite)shell, 2562);
                    GridData data = new GridData(4, 4, true, true, 2, 1);
                    table.setLayoutData((Object)data);
                    for (int i = ((PartContainer)PartContainer.this).part.low; i <= ((PartContainer)PartContainer.this).part.high; ++i) {
                        table.add(String.valueOf(i));
                    }
                    try {
                        table.select(PartContainer.this.part.createInstance(PartContainer.this.text.getText()).getIntArray(-((PartContainer)PartContainer.this).part.low));
                    }
                    catch (DataParseException dpe) {
                        ExceptionHandler.reportException(dpe);
                    }
                    Button buttonOk = new Button((Composite)shell, 0);
                    GridData buttonOkLData = new GridData();
                    buttonOkLData.grabExcessHorizontalSpace = true;
                    buttonOkLData.horizontalAlignment = 131072;
                    buttonOkLData.widthHint = 100;
                    buttonOkLData.heightHint = 25;
                    buttonOk.setLayoutData((Object)buttonOkLData);
                    buttonOk.setText(Messages.getString("CrontabScheduleOptions.Ok"));
                    buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PartContainer.this.text.setText(((PartContainer)PartContainer.this).part.createInstance((int[])table.getSelectionIndices(), (int)(-((PartContainer)PartContainer.this).part.low)).pattern);
                            shell.dispose();
                        }
                    });
                    Button buttonClose = new Button((Composite)shell, 0);
                    GridData buttonCloseLData = new GridData();
                    buttonCloseLData.horizontalAlignment = 4;
                    buttonCloseLData.widthHint = 100;
                    buttonCloseLData.heightHint = 25;
                    buttonClose.setLayoutData((Object)buttonCloseLData);
                    buttonClose.setText(Messages.getString("CrontabScheduleOptions.Close"));
                    buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            shell.dispose();
                        }
                    });
                    shell.setLocation(PartContainer.this.buttonChoose.toDisplay(0, 0));
                    shell.setSize(300, 300);
                    shell.layout();
                    shell.open();
                    Display display = CrontabScheduleOptions.this.getDisplay();
                    while (!shell.isDisposed()) {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                }
            });
        }

        public void setInstance(CrontabPart.Instance instance) {
            if (instance.all) {
                this.text.setText("*");
            } else {
                this.text.setText(instance.pattern);
            }
            this.cbAll.setSelection(instance.all);
            this.text.setEnabled(!instance.all);
            this.buttonChoose.setEnabled(!instance.all);
        }

        public CrontabPart.Instance getInstance() throws DataParseException {
            String pattern = this.text.getText();
            if (this.cbAll.getSelection()) {
                pattern = "*";
            }
            return this.part.createInstance(pattern);
        }
    }
}

