/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.net.URISyntaxException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.UserPasswordSpecificComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class FTPSpecificComposite
extends UserPasswordSpecificComposite {
    private static final String FTP_ANONYMOUS_USERNAME = "Anonymous";
    Combo comboAuthentication;

    @Override
    public int getDefaultPort() {
        return 21;
    }

    @Override
    protected void onBeforePasswordHook(Composite parent) {
        super.onBeforePasswordHook(parent);
        Label labelAuthenticationType = new Label(parent, 0);
        labelAuthenticationType.setText(Messages.getString("ProtocolSpecificComposite.FTPAuthType"));
        this.comboAuthentication = new Combo(parent, 8);
        GridData comboAuthenticationData = new GridData();
        comboAuthenticationData.horizontalSpan = 2;
        comboAuthenticationData.horizontalAlignment = 4;
        this.comboAuthentication.setLayoutData((Object)comboAuthenticationData);
        this.comboAuthentication.add(Messages.getString("ProtocolSpecificComposite.FTPAuthTypeAnonymous"));
        this.comboAuthentication.add(Messages.getString("ProtocolSpecificComposite.FTPAuthTypeUserPassword"));
    }

    @Override
    public void createGUI(Composite parent) {
        super.createGUI(parent);
        this.setUserPasswordEnabled(false);
        this.comboAuthentication.select(0);
        this.comboAuthentication.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FTPSpecificComposite.this.setUserPasswordEnabled(FTPSpecificComposite.this.comboAuthentication.getSelectionIndex() == 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connection) {
        super.setConnectionDescription(connection);
        if (FTP_ANONYMOUS_USERNAME.equals(connection.getParameter("username"))) {
            this.comboAuthentication.select(0);
        } else {
            this.comboAuthentication.select(1);
        }
        this.setUserPasswordEnabled(this.comboAuthentication.getSelectionIndex() == 1);
    }

    @Override
    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        ConnectionDescription connection = super.getConnectionDescription();
        if (this.comboAuthentication.getSelectionIndex() == 0) {
            connection.setParameter("username", FTP_ANONYMOUS_USERNAME);
            connection.setSecretParameter("password", "");
        }
        return connection;
    }
}

