/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.Vector;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.FileFilterManager;
import net.sourceforge.fullsync.rules.filefilter.FileFilterRule;
import net.sourceforge.fullsync.rules.filefilter.values.OperandValue;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.WizardDialog;
import net.sourceforge.fullsync.ui.filterrule.FilterRuleListItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FileFilterPage
extends WizardDialog {
    private Combo comboFilterType;
    private Label label1;
    private Combo comboMatchType;
    private Label label2;
    private ScrolledComposite scrolledComposite1;
    private Composite compositeRuleList;
    private Button buttonAppliesToDir;
    private FileFilterManager fileFilterManager = new FileFilterManager();
    private FileFilter fileFilter;
    private Vector<FilterRuleListItem> ruleItems = new Vector();

    public FileFilterPage(Shell parent, FileFilter filter) {
        super(parent);
        this.fileFilter = filter;
    }

    @Override
    public String getTitle() {
        return "File Filter";
    }

    @Override
    public String getCaption() {
        return "Edit the file filter";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Image getIcon() {
        return GuiController.getInstance().getImage("FileFilter_Default.png");
    }

    @Override
    public Image getImage() {
        return GuiController.getInstance().getImage("FileFilter_Wizard.png");
    }

    @Override
    public void createContent(Composite content) {
        try {
            content.setLayout((Layout)new GridLayout(4, false));
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            content.setSize(700, 500);
            this.comboFilterType = new Combo(content, 12);
            this.comboFilterType.add("Include");
            this.comboFilterType.add("Exclude");
            this.label1 = new Label(content, 0);
            this.label1.setText(" any file that matches ");
            this.comboMatchType = new Combo(content, 12);
            this.comboMatchType.add("all");
            this.comboMatchType.add("any");
            this.label2 = new Label(content, 0);
            this.label2.setText("of the following");
            this.buttonAppliesToDir = new Button(content, 16416);
            this.buttonAppliesToDir.setText("Applies to directories");
            GridData buttonAppliesToDirLData = new GridData();
            buttonAppliesToDirLData.horizontalSpan = 4;
            this.buttonAppliesToDir.setLayoutData((Object)buttonAppliesToDirLData);
            GridData scrolledComposite1LData = new GridData(4, 4, true, true);
            scrolledComposite1LData.horizontalSpan = 4;
            this.scrolledComposite1 = new ScrolledComposite(content, 2816);
            this.createCompositeRuleList();
            this.scrolledComposite1.setLayoutData((Object)scrolledComposite1LData);
            this.scrolledComposite1.setAlwaysShowScrollBars(false);
            if (this.fileFilter != null) {
                this.comboMatchType.select(this.fileFilter.getMatchType());
                this.comboFilterType.select(this.fileFilter.getFilterType());
                this.buttonAppliesToDir.setSelection(this.fileFilter.appliesToDirectories());
                FileFilterRule[] rules = this.fileFilter.getFileFiltersRules();
                if (rules.length > 0) {
                    for (FileFilterRule rule : rules) {
                        this.addRuleRow(rule.getRuleType(), rule.getOperator(), rule.getValue());
                    }
                } else {
                    this.addRuleRow();
                }
            } else {
                this.comboMatchType.select(0);
                this.comboFilterType.select(0);
                this.buttonAppliesToDir.setSelection(true);
                this.addRuleRow();
            }
            content.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean apply() {
        this.fileFilter = new FileFilter();
        this.fileFilter.setMatchType(this.comboMatchType.getSelectionIndex());
        this.fileFilter.setFilterType(this.comboFilterType.getSelectionIndex());
        this.fileFilter.setAppliesToDirectories(this.buttonAppliesToDir.getSelection());
        FileFilterRule[] rules = new FileFilterRule[this.ruleItems.size()];
        for (int i = 0; i < rules.length; ++i) {
            FilterRuleListItem ruleItem = this.ruleItems.get(i);
            rules[i] = this.fileFilterManager.createFileFilterRule(ruleItem.getRuleType(), ruleItem.getOperator(), ruleItem.getValue());
        }
        this.fileFilter.setFileFilterRules(rules);
        return true;
    }

    @Override
    public boolean cancel() {
        this.fileFilter = null;
        return true;
    }

    public void addRuleRow() {
        this.addRuleRow(null, -1, null);
    }

    protected void addRuleRow(String ruleType, int op, OperandValue value) {
        FilterRuleListItem ruleItem = new FilterRuleListItem(this, this.compositeRuleList, this.fileFilterManager, ruleType, op, value);
        this.ruleItems.add(ruleItem);
        this.compositeRuleList.pack();
    }

    public void recreateRuleList() {
        this.compositeRuleList.dispose();
        this.createCompositeRuleList();
        for (FilterRuleListItem item : this.ruleItems) {
            item.init(this.compositeRuleList);
        }
        this.compositeRuleList.pack();
    }

    public void deleteRule(FilterRuleListItem item) {
        if (this.ruleItems.size() > 1) {
            this.ruleItems.remove(item);
            this.recreateRuleList();
        }
    }

    protected void createCompositeRuleList() {
        this.compositeRuleList = new Composite((Composite)this.scrolledComposite1, 4);
        GridData layoutData = new GridData(4, 4, true, true);
        this.compositeRuleList.setLayoutData((Object)layoutData);
        this.scrolledComposite1.setContent((Control)this.compositeRuleList);
        this.compositeRuleList.setLayout((Layout)new GridLayout(4, false));
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }
}

