/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.GuiController;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class FileObjectChooser
extends Dialog {
    private Shell dialogShell;
    private Text textUrlExtension;
    private Text textFilename;
    private ToolItem toolItemNewFolder;
    private Composite compositeBottom;
    private TableColumn tableColumnName;
    private TableColumn tableColumnDateModified;
    private TableColumn tableColumnType;
    private TableColumn tableColumnSize;
    private ToolItem toolItemParent;
    private Button buttonCancel;
    private Button buttonOk;
    private Combo comboFileFilter;
    private ToolBar toolBarActions;
    private Composite compositeTop;
    private Table tableItems;
    private boolean result;
    private FileObject baseFileObject;
    private FileObject rootFileObject;
    private FileObject activeFileObject;
    private FileObject selectedFileObject;

    public FileObjectChooser(Shell parent, int style) {
        super(parent, style);
    }

    public boolean open() {
        try {
            this.result = false;
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 67632);
            this.dialogShell.setText("Choose File...");
            this.dialogShell.setLayout((Layout)new GridLayout());
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(550, 400);
            this.compositeTop = new Composite((Composite)this.dialogShell, 0);
            GridLayout composite1Layout = new GridLayout(4, false);
            GridData compositeTopLData = new GridData();
            compositeTopLData.horizontalAlignment = 4;
            this.compositeTop.setLayoutData((Object)compositeTopLData);
            this.compositeTop.setLayout((Layout)composite1Layout);
            Label labelUrl = new Label(this.compositeTop, 0);
            labelUrl.setText("Url:");
            Label labelBaseUrl = new Label(this.compositeTop, 0);
            labelBaseUrl.setText(this.rootFileObject.getName().toString());
            this.textUrlExtension = new Text(this.compositeTop, 2048);
            GridData textUrlExtensionLData = new GridData();
            textUrlExtensionLData.grabExcessHorizontalSpace = true;
            textUrlExtensionLData.horizontalAlignment = 4;
            this.textUrlExtension.setLayoutData((Object)textUrlExtensionLData);
            this.toolBarActions = new ToolBar(this.compositeTop, 0);
            this.toolItemParent = new ToolItem(this.toolBarActions, 0);
            this.toolItemParent.setImage(GuiController.getInstance().getImage("FS_LevelUp.gif"));
            this.toolItemParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileObjectChooser.this.toolItemParentWidgetSelected(evt);
                }
            });
            this.toolItemNewFolder = new ToolItem(this.toolBarActions, 0);
            this.toolItemNewFolder.setImage(GuiController.getInstance().getImage("FS_Folder_New.gif"));
            this.toolItemNewFolder.setDisabledImage(GuiController.getInstance().getImage("FS_Folder_New_disabled.gif"));
            this.toolItemNewFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileObjectChooser.this.toolItemNewFolderWidgetSelected(evt);
                }
            });
            this.toolItemNewFolder.setEnabled(false);
            GridData tableItemsLData = new GridData();
            tableItemsLData.grabExcessHorizontalSpace = true;
            tableItemsLData.grabExcessVerticalSpace = true;
            tableItemsLData.horizontalAlignment = 4;
            tableItemsLData.verticalAlignment = 4;
            this.tableItems = new Table((Composite)this.dialogShell, 2052);
            this.tableItems.setHeaderVisible(true);
            this.tableItems.setLayoutData((Object)tableItemsLData);
            this.tableItems.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent evt) {
                    FileObjectChooser.this.tableItemsMouseDown(evt);
                }

                public void mouseDoubleClick(MouseEvent evt) {
                    FileObjectChooser.this.tableItemsMouseDoubleClick(evt);
                }
            });
            this.tableColumnName = new TableColumn(this.tableItems, 0);
            this.tableColumnName.setText("File name");
            this.tableColumnName.setWidth(200);
            this.tableColumnSize = new TableColumn(this.tableItems, 0);
            this.tableColumnSize.setText("Size");
            this.tableColumnSize.setWidth(60);
            this.tableColumnType = new TableColumn(this.tableItems, 0);
            this.tableColumnType.setText("Type");
            this.tableColumnType.setWidth(100);
            this.tableColumnDateModified = new TableColumn(this.tableItems, 0);
            this.tableColumnDateModified.setText("Date Modified");
            this.tableColumnDateModified.setWidth(145);
            this.compositeBottom = new Composite((Composite)this.dialogShell, 0);
            GridLayout compositeBottomLayout = new GridLayout();
            compositeBottomLayout.numColumns = 3;
            GridData compositeBottomLData = new GridData();
            compositeBottomLData.horizontalAlignment = 4;
            this.compositeBottom.setLayoutData((Object)compositeBottomLData);
            this.compositeBottom.setLayout((Layout)compositeBottomLayout);
            Label labelFilename = new Label(this.compositeBottom, 0);
            labelFilename.setText("File name:");
            GridData textFilenameLData = new GridData();
            textFilenameLData.horizontalAlignment = 4;
            textFilenameLData.grabExcessHorizontalSpace = true;
            this.textFilename = new Text(this.compositeBottom, 2048);
            this.textFilename.setLayoutData((Object)textFilenameLData);
            this.buttonOk = new Button(this.compositeBottom, 0x1000008);
            GridData buttonOkLData = new GridData();
            buttonOkLData.horizontalAlignment = 2;
            buttonOkLData.widthHint = 100;
            buttonOkLData.heightHint = 25;
            this.buttonOk.setLayoutData((Object)buttonOkLData);
            this.buttonOk.setText("Open");
            this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileObjectChooser.this.buttonOkWidgetSelected(evt);
                }
            });
            Label labelFileFilter = new Label(this.compositeBottom, 0);
            labelFileFilter.setText("Files of type:");
            this.comboFileFilter = new Combo(this.compositeBottom, 0);
            GridData comboFileFilterLData = new GridData();
            comboFileFilterLData.horizontalAlignment = 4;
            this.comboFileFilter.setLayoutData((Object)comboFileFilterLData);
            this.comboFileFilter.setText("all files");
            this.comboFileFilter.setEnabled(false);
            this.buttonCancel = new Button(this.compositeBottom, 0x1000008);
            GridData buttonCancelLData = new GridData();
            buttonCancelLData.widthHint = 100;
            buttonCancelLData.heightHint = 25;
            this.buttonCancel.setLayoutData((Object)buttonCancelLData);
            this.buttonCancel.setText("Cancel");
            this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileObjectChooser.this.buttonCancelWidgetSelected(evt);
                }
            });
            this.updateActiveFileObject();
            this.updateSelectedFileObject();
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return this.result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void populateList() throws FileSystemException {
        FileObject[] children = this.activeFileObject.getChildren();
        Arrays.sort(children, new Comparator<FileObject>(){

            @Override
            public int compare(FileObject o1, FileObject o2) {
                try {
                    if (o1.getType() == FileType.FOLDER && o2.getType() == FileType.FILE) {
                        return -1;
                    }
                    if (o1.getType() == FileType.FILE && o2.getType() == FileType.FOLDER) {
                        return 1;
                    }
                    return o1.getName().getBaseName().compareTo(o2.getName().getBaseName());
                }
                catch (FileSystemException fse) {
                    fse.printStackTrace();
                    return 0;
                }
            }
        });
        DateFormat df = DateFormat.getDateTimeInstance();
        for (int i = 0; i < children.length; ++i) {
            FileObject data = children[i];
            TableItem item = this.tableItems.getItemCount() <= i ? new TableItem(this.tableItems, 0) : this.tableItems.getItem(i);
            item.setText(0, data.getName().getBaseName());
            String type = data.getType().getName();
            if (data.getType().hasContent()) {
                FileContent content = data.getContent();
                String contentType = content.getContentInfo().getContentType();
                if (contentType != null) {
                    type = type + " (" + contentType + ")";
                }
                item.setText(1, String.valueOf(content.getSize()));
                item.setText(3, df.format(new Date(content.getLastModifiedTime())));
            } else {
                item.setText(1, "");
                item.setText(3, "");
            }
            item.setText(2, type);
            if (data.getType() == FileType.FOLDER) {
                item.setImage(GuiController.getInstance().getImage("FS_Folder_Collapsed.gif"));
            } else {
                item.setImage(GuiController.getInstance().getImage("FS_File_text_plain.gif"));
            }
            item.setData((Object)data);
        }
        this.tableItems.setItemCount(children.length);
    }

    private void updateActiveFileObject() throws FileSystemException {
        this.tableItems.deselectAll();
        this.populateList();
        this.textUrlExtension.setText(this.rootFileObject.getName().getRelativeName(this.activeFileObject.getName()));
    }

    private void updateSelectedFileObject() throws FileSystemException {
        if (this.selectedFileObject != null) {
            this.textFilename.setText(this.selectedFileObject.getName().getBaseName());
        } else {
            this.textFilename.setText("");
        }
    }

    public void setBaseFileObject(FileObject baseFileObject) {
        this.baseFileObject = baseFileObject;
        if (this.activeFileObject == null) {
            this.activeFileObject = baseFileObject;
        }
        try {
            this.rootFileObject = baseFileObject.resolveFile("/");
        }
        catch (FileSystemException e) {
            ExceptionHandler.reportException(e);
        }
    }

    public FileObject getBaseFileObject() {
        return this.baseFileObject;
    }

    public void setActiveFileObject(FileObject active) throws FileSystemException {
        this.activeFileObject = active;
        if (this.dialogShell != null) {
            this.updateActiveFileObject();
        }
    }

    public FileObject getActiveFileObject() {
        return this.activeFileObject;
    }

    public void setSelectedFileObject(FileObject selected) throws FileSystemException {
        this.selectedFileObject = selected;
        if (this.dialogShell != null) {
            this.updateSelectedFileObject();
        }
    }

    public FileObject getSelectedFileObject() {
        return this.selectedFileObject;
    }

    private void toolItemParentWidgetSelected(SelectionEvent evt) {
        try {
            FileObject parent = this.activeFileObject.getParent();
            if (parent != null) {
                this.setActiveFileObject(parent);
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    private void toolItemNewFolderWidgetSelected(SelectionEvent evt) {
    }

    private void tableItemsMouseDoubleClick(MouseEvent evt) {
        TableItem[] items = this.tableItems.getSelection();
        if (items.length > 0) {
            try {
                TableItem item = items[0];
                FileObject file = (FileObject)item.getData();
                if (file.getType().hasChildren()) {
                    this.setActiveFileObject(file);
                }
            }
            catch (FileSystemException fse) {
                fse.printStackTrace();
            }
        }
    }

    private void tableItemsMouseDown(MouseEvent evt) {
        TableItem[] items = this.tableItems.getSelection();
        if (items.length > 0) {
            try {
                TableItem item = items[0];
                FileObject file = (FileObject)item.getData();
                this.setSelectedFileObject(file);
            }
            catch (FileSystemException fse) {
                fse.printStackTrace();
            }
        }
    }

    private void buttonOkWidgetSelected(SelectionEvent evt) {
        this.result = true;
        this.dialogShell.dispose();
    }

    private void buttonCancelWidgetSelected(SelectionEvent evt) {
        this.result = false;
        this.dialogShell.dispose();
    }
}

