/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ui.ProtocolSpecificComposite;
import org.eclipse.swt.widgets.DirectoryDialog;

class FileSpecificComposite
extends ProtocolSpecificComposite {
    FileSpecificComposite() {
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connection) {
        super.setConnectionDescription(connection);
        if (null != connection) {
            this.textPath.setText(connection.getDisplayPath());
        } else {
            this.textPath.setText("");
        }
    }

    @Override
    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        File f = new File(this.textPath.getText());
        return new ConnectionDescription(f.toURI());
    }

    @Override
    public void onBrowse() {
        String dir;
        ConnectionDescription desc = null;
        try {
            desc = this.getConnectionDescription();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        DirectoryDialog d = new DirectoryDialog(this.m_parent.getShell());
        if (null != desc) {
            d.setFilterPath(desc.getUri().getPath());
        }
        if ((dir = d.open()) != null) {
            File f = new File(dir);
            try {
                this.setPath(f.getCanonicalPath());
            }
            catch (IOException e) {
                this.setPath("");
                e.printStackTrace();
            }
        }
    }
}

