/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;

public class FontRepository {
    private Device dev;
    private HashMap<Key, Font> cache;

    public FontRepository(Device _device) {
        this.dev = _device;
        this.cache = new HashMap(5);
    }

    public Font getFont(String name, int height, int style) {
        Key key = new Key(name, height, style);
        Font font = this.cache.get(key);
        if (null == font) {
            font = new Font(this.dev, name, height, style);
        }
        return font;
    }

    public void dispose() {
        for (Font f : this.cache.values()) {
            f.dispose();
        }
        this.cache.clear();
    }

    private static class Key {
        private String name;
        private int height;
        private int style;
        private int hash;

        Key(String _name, int _height, int _style) {
            this.name = _name;
            this.height = _height;
            this.style = _style;
            this.hash = (this.name + "#" + this.height + "#" + this.style).hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key k = (Key)obj;
                return this.height == k.height && this.style == k.style && 0 == this.name.compareTo(k.name);
            }
            return false;
        }
    }
}

