/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class GUIUpdateQueue<Item> {
    private Display m_display;
    private ConcurrentLinkedQueue<Item> m_queue;
    private AtomicBoolean m_updateScheduled;
    private GUIUpdateTask<Item> m_updateTask;

    public GUIUpdateQueue(Display display, GUIUpdateTask<Item> guiUpdateTask) {
        this.m_display = display;
        this.m_queue = new ConcurrentLinkedQueue();
        this.m_updateScheduled = new AtomicBoolean(false);
        this.m_updateTask = guiUpdateTask;
    }

    public synchronized void add(Item item) {
        this.m_queue.add(item);
        if (!this.m_updateScheduled.get()) {
            this.m_updateScheduled.set(true);
            this.m_display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LinkedList items = new LinkedList();
                    GUIUpdateQueue.this.getItems(items);
                    if (!items.isEmpty()) {
                        GUIUpdateQueue.this.m_updateTask.doUpdate(GUIUpdateQueue.this.m_display, items);
                    }
                }
            });
        }
    }

    private synchronized void getItems(LinkedList<Item> items) {
        Item item;
        while (null != (item = this.m_queue.poll())) {
            items.add(item);
        }
        this.m_updateScheduled.set(false);
    }

    public static interface GUIUpdateTask<Item> {
        public void doUpdate(Display var1, LinkedList<Item> var2);
    }
}

