/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Preferences;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.ui.AsyncUIUpdate;
import net.sourceforge.fullsync.ui.ExceptionDialog;
import net.sourceforge.fullsync.ui.ExecuteBackgroundJob;
import net.sourceforge.fullsync.ui.FontRepository;
import net.sourceforge.fullsync.ui.ImageRepository;
import net.sourceforge.fullsync.ui.MainWindow;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.SystemTrayItem;
import net.sourceforge.fullsync.ui.WelcomeScreen;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class GuiController
implements Runnable {
    private static GuiController singleton;
    private final Preferences preferences;
    private final ProfileManager profileManager;
    private final Synchronizer synchronizer;
    private ExceptionHandler oldExceptionHandler;
    private Display display;
    private ImageRepository imageRepository;
    private FontRepository fontRepository;
    private Shell mainShell;
    private MainWindow mainWindow;
    private SystemTrayItem systemTrayItem;
    private final ScheduledThreadPoolExecutor executorService;

    private GuiController(Preferences preferences, ProfileManager profileManager, Synchronizer synchronizer) {
        this.preferences = preferences;
        this.profileManager = profileManager;
        this.synchronizer = synchronizer;
        this.executorService = new ScheduledThreadPoolExecutor(1);
    }

    private void createMainShell(boolean minimized) {
        try {
            this.mainShell = new Shell(this.display);
            this.mainWindow = new MainWindow((Composite)this.mainShell, 0, this);
            this.mainShell.setLayout((Layout)new FillLayout());
            Rectangle shellBounds = this.mainShell.computeTrim(0, 0, this.mainWindow.getSize().x, this.mainWindow.getSize().y);
            this.mainShell.setSize(shellBounds.width, shellBounds.height);
            this.mainShell.setText("FullSync");
            this.mainShell.setImage(this.getImage("fullsync48.png"));
            this.restoreWindowState(shellBounds);
            if (minimized) {
                this.mainShell.setVisible(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    private void restoreWindowState(Rectangle shellBounds) {
        this.mainShell.setVisible(true);
        Rectangle wb = this.preferences.getWindowBounds();
        boolean maximized = this.preferences.getWindowMaximized();
        boolean minimized = this.preferences.getWindowMinimized();
        Rectangle r = this.display.getBounds();
        if (wb.width > 0 && wb.height > 0 && r.contains(wb.x, wb.y) && r.contains(wb.x + wb.width, wb.y + wb.height)) {
            this.mainShell.setBounds(wb);
        }
        if (minimized) {
            this.mainShell.setMinimized(true);
        }
        if (maximized) {
            this.mainShell.setMaximized(true);
        }
    }

    public void setMainShellVisible(boolean visible) {
        this.mainShell.setVisible(visible);
        this.mainShell.setMinimized(!visible);
    }

    public Shell getMainShell() {
        return this.mainShell;
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Image getImage(String imageName) {
        return this.imageRepository.getImage(imageName);
    }

    public void startGui(boolean minimized) {
        Display.setAppName((String)"FullSync");
        this.display = Display.getDefault();
        this.imageRepository = new ImageRepository(this.display);
        this.fontRepository = new FontRepository((Device)this.display);
        this.createMainShell(minimized);
        this.systemTrayItem = new SystemTrayItem(this);
        this.oldExceptionHandler = ExceptionHandler.registerExceptionHandler(new ExceptionHandler(){

            @Override
            protected void doReportException(final String message, final Throwable exception) {
                exception.printStackTrace();
                GuiController.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new ExceptionDialog(GuiController.this.mainShell, message, exception);
                    }
                });
            }
        });
        this.createWelcomeScreen();
    }

    @Override
    public void run() {
        while (!this.mainShell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void closeGui() {
        if (this.profileManager.getNextScheduleTask() != null && this.preferences.confirmExit()) {
            MessageBox mb = new MessageBox(this.mainShell, 200);
            mb.setText(Messages.getString("GuiController.Confirmation"));
            mb.setMessage(Messages.getString("GuiController.Do_You_Want_To_Quit") + "\n" + Messages.getString("GuiController.Schedule_is_stopped"));
            if (mb.open() != 64) {
                return;
            }
        }
        this.profileManager.disconnectRemote();
        this.synchronizer.disconnectRemote();
        this.storeWindowState();
        this.disposeGui();
    }

    private void storeWindowState() {
        boolean maximized = this.mainShell.getMaximized();
        boolean minimized = this.mainShell.getMinimized();
        if (!maximized) {
            this.preferences.setWindowBounds(this.mainShell.getBounds());
        }
        this.preferences.setWindowMaximized(maximized);
        this.preferences.setWindowMinimized(minimized);
        this.preferences.save();
    }

    public void disposeGui() {
        ExceptionHandler.registerExceptionHandler(this.oldExceptionHandler);
        if (this.mainShell != null && !this.mainShell.isDisposed()) {
            this.mainShell.dispose();
        }
        if (this.imageRepository != null) {
            this.imageRepository.dispose();
        }
        if (this.fontRepository != null) {
            this.fontRepository.dispose();
        }
        if (this.systemTrayItem != null && !this.systemTrayItem.isDisposed()) {
            this.systemTrayItem.dispose();
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.dispose();
        }
    }

    public void showBusyCursor(final boolean show) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Shell[] shells;
                    Cursor cursor = show ? GuiController.this.display.getSystemCursor(1) : null;
                    for (Shell shell : shells = GuiController.this.display.getShells()) {
                        shell.setCursor(cursor);
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.reportException(ex);
                }
            }
        });
    }

    public static GuiController getInstance() {
        return singleton;
    }

    public static GuiController initialize(Preferences preferences, ProfileManager profileManager, Synchronizer synchronizer) {
        singleton = new GuiController(preferences, profileManager, synchronizer);
        return singleton;
    }

    public static void launchProgram(final String uri) {
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Process p = Runtime.getRuntime().exec(new String[]{"xdg-open", uri});
                        p.waitFor();
                    }
                    catch (IOException e) {
                        ExceptionHandler.reportException("Error opening " + uri + ".", e);
                    }
                    catch (InterruptedException e) {
                        ExceptionHandler.reportException("Error opening " + uri + ".", e);
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        } else {
            try {
                Program.launch((String)uri);
            }
            catch (Exception e) {
                ExceptionHandler.reportException("Error opening " + uri + ".", e);
            }
        }
    }

    public Font getFont(String name, int height, int style) {
        return this.fontRepository.getFont(name, height, style);
    }

    private void createWelcomeScreen() {
        if (null != System.getProperty("net.sourceforge.fullsync.skipWelcomeScreen", null) || this.preferences.getSkipWelcomeScreen()) {
            return;
        }
        if (this.preferences.getLastVersion().equals(Util.getFullSyncVersion())) {
            return;
        }
        this.preferences.save();
        try {
            new WelcomeScreen(this.getMainShell());
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    public static void backgroundExec(AsyncUIUpdate job) {
        GuiController gc = GuiController.getInstance();
        gc.executorService.execute(new ExecuteBackgroundJob(job, gc.display));
    }
}

