/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.File;
import java.io.IOException;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportProfilesPage
extends WizardDialog {
    private Composite composite;
    private Text textPath;
    private Button buttonBrowse;

    public ImportProfilesPage(Shell parent) {
        super(parent);
    }

    @Override
    public String getTitle() {
        return Messages.getString("ImportProfilesPage.ImportProfiles");
    }

    @Override
    public String getCaption() {
        return Messages.getString("ImportProfilesPage.ImportProfiles");
    }

    @Override
    public String getDescription() {
        return Messages.getString("ImportProfilesPage.ImportProfilesDescription");
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public void createContent(final Composite content) {
        this.composite = content;
        content.setLayout((Layout)new GridLayout(2, false));
        this.textPath = new Text(content, 2048);
        GridData textData = new GridData();
        textData.horizontalAlignment = 4;
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.verticalAlignment = 0x1000000;
        this.textPath.setLayoutData((Object)textData);
        this.buttonBrowse = new Button(content, 0);
        this.buttonBrowse.setText("...");
        this.buttonBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog fd = new FileDialog(content.getShell());
                fd.setFileName("profiles.xml");
                fd.setFilterExtensions(new String[]{"profiles.xml", "*.xml", "*"});
                fd.setFilterIndex(0);
                fd.setFilterPath(ImportProfilesPage.this.textPath.getText());
                String file = fd.open();
                if (file != null) {
                    File f = new File(file);
                    try {
                        ImportProfilesPage.this.textPath.setText(f.getCanonicalPath());
                    }
                    catch (IOException e) {
                        ImportProfilesPage.this.textPath.setText("");
                        e.printStackTrace();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
            }
        });
    }

    @Override
    public boolean apply() {
        try {
            if (GuiController.getInstance().getProfileManager().loadProfiles(this.textPath.getText())) {
                return true;
            }
            MessageBox mb = new MessageBox(this.composite.getShell(), 40);
            mb.setText(Messages.getString("ImportProfilesPage.ProfilesFileNotFoundTitle"));
            mb.setMessage(Messages.getString("ImportProfilesPage.ProfilesFileNotFound"));
            mb.open();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
        return false;
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

