/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.schedule.IntervalSchedule;
import net.sourceforge.fullsync.schedule.Schedule;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ScheduleOptions;
import net.sourceforge.fullsync.ui.SchedulingIntervalItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IntervalScheduleOptions
extends ScheduleOptions {
    private static SchedulingIntervalItem[] schedulingIntervals = new SchedulingIntervalItem[]{new SchedulingIntervalItem("seconds", Messages.getString("IntervalScheduleOptions.seconds"), 1000L), new SchedulingIntervalItem("minutes", Messages.getString("IntervalScheduleOptions.minutes"), 60000L), new SchedulingIntervalItem("hours", Messages.getString("IntervalScheduleOptions.hours"), 3600000L)};
    private Text textCount;
    private Combo cbUnit;

    public IntervalScheduleOptions(Composite parent, int style) {
        super(parent, style);
        try {
            GridLayout thisLayout = new GridLayout(3, false);
            this.setLayout((Layout)thisLayout);
            Label labelExecuteQuery = new Label((Composite)this, 0);
            labelExecuteQuery.setText(Messages.getString("IntervalScheduleOptions.ExecuteEvery"));
            GridData labelIntervalData = new GridData();
            labelExecuteQuery.setLayoutData((Object)labelIntervalData);
            this.textCount = new Text((Composite)this, 133120);
            this.textCount.setText("1");
            GridData textCountLData = new GridData();
            textCountLData.grabExcessHorizontalSpace = true;
            textCountLData.horizontalAlignment = 4;
            this.textCount.setLayoutData((Object)textCountLData);
            this.cbUnit = new Combo((Composite)this, 12);
            String[] names = new String[schedulingIntervals.length];
            int idx = 0;
            for (SchedulingIntervalItem item : schedulingIntervals) {
                names[idx++] = item.name;
            }
            this.cbUnit.setItems(names);
            this.layout();
            this.cbUnit.select(0);
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public String getSchedulingName() {
        return Messages.getString("IntervalScheduleOptions.Interval");
    }

    @Override
    public boolean canHandleSchedule(Schedule sched) {
        return sched instanceof IntervalSchedule;
    }

    @Override
    public void setSchedule(Schedule sched) {
        if (sched instanceof IntervalSchedule) {
            IntervalSchedule is = (IntervalSchedule)sched;
            int index = 0;
            for (SchedulingIntervalItem item : schedulingIntervals) {
                if (item.unit.equals(is.getIntervalDisplayUnit())) {
                    this.textCount.setText(String.valueOf(is.getInterval() / item.factor));
                    break;
                }
                ++index;
            }
            this.cbUnit.select(index);
        }
    }

    @Override
    public Schedule getSchedule() {
        SchedulingIntervalItem item = schedulingIntervals[this.cbUnit.getSelectionIndex()];
        long interval = Long.parseLong(this.textCount.getText()) * item.factor;
        return new IntervalSchedule(interval, interval, item.unit);
    }
}

