/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileListChangeListener;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ProfileListComposite;
import net.sourceforge.fullsync.ui.ProfileListControlHandler;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListViewProfileListComposite
extends ProfileListComposite
implements ProfileListChangeListener {
    private Table tableProfiles = new Table((Composite)this, 67584);
    private TableColumn tableColumnName = new TableColumn(this.tableProfiles, 0);
    private TableColumn tableColumnLastUpdate;
    private TableColumn tableColumnNextUpdate;
    private TableColumn tableColumnSource;
    private TableColumn tableColumnDestination;
    private ProfileManager profileManager;
    private ProfileListControlHandler handler;

    public ListViewProfileListComposite(Composite parent, int style) {
        super(parent, style);
        this.tableColumnName.setText(Messages.getString("ListViewProfileListComposite.Name"));
        this.tableColumnName.setWidth(100);
        this.tableColumnLastUpdate = new TableColumn(this.tableProfiles, 0);
        this.tableColumnLastUpdate.setText(Messages.getString("ListViewProfileListComposite.LastUpdate"));
        this.tableColumnLastUpdate.setWidth(100);
        this.tableColumnNextUpdate = new TableColumn(this.tableProfiles, 0);
        this.tableColumnNextUpdate.setText(Messages.getString("ListViewProfileListComposite.NextUpdate"));
        this.tableColumnNextUpdate.setWidth(100);
        this.tableColumnSource = new TableColumn(this.tableProfiles, 0);
        this.tableColumnSource.setText(Messages.getString("ListViewProfileListComposite.Source"));
        this.tableColumnSource.setWidth(200);
        this.tableColumnDestination = new TableColumn(this.tableProfiles, 0);
        this.tableColumnDestination.setText(Messages.getString("ListViewProfileListComposite.Destination"));
        this.tableColumnDestination.setWidth(200);
        this.tableProfiles.setHeaderVisible(true);
        this.tableProfiles.setLinesVisible(false);
        this.setLayout((Layout)new FillLayout());
        this.layout();
    }

    public void populateProfileList() {
        if (this.profileManager != null) {
            this.tableProfiles.clearAll();
            this.tableProfiles.setItemCount(0);
            for (Profile p : this.profileManager.getProfiles()) {
                TableItem item = new TableItem(this.tableProfiles, 0);
                String[] cells = new String[]{p.getName(), p.getLastUpdateText(), p.getNextUpdateText(), p.getSource().toString(), p.getDestination().toString()};
                item.setText(cells);
                item.setData((Object)p);
            }
            this.tableColumnName.pack();
            this.tableColumnLastUpdate.pack();
            this.tableColumnNextUpdate.pack();
            this.tableColumnSource.pack();
            this.tableColumnDestination.pack();
        }
    }

    public void dispose() {
        this.profileManager.removeProfilesChangeListener(this);
        super.dispose();
    }

    @Override
    public Profile getSelectedProfile() {
        Profile p = null;
        TableItem[] sel = this.tableProfiles.getSelection();
        if (sel.length > 0) {
            p = (Profile)sel[0].getData();
        }
        return p;
    }

    @Override
    public void setProfileManager(ProfileManager profileManager) {
        if (this.profileManager != null) {
            profileManager.removeProfilesChangeListener(this);
        }
        this.profileManager = profileManager;
        if (this.profileManager != null) {
            profileManager.addProfilesChangeListener(this);
        }
        this.populateProfileList();
    }

    @Override
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @Override
    public ProfileListControlHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(ProfileListControlHandler handler) {
        this.handler = handler;
    }

    public void setMenu(Menu menu) {
        this.tableProfiles.setMenu(menu);
    }

    public Menu getMenu() {
        return this.tableProfiles.getMenu();
    }

    @Override
    public void profileChanged(Profile p) {
        this.profileListChanged();
    }

    @Override
    public void profileListChanged() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ListViewProfileListComposite.this.populateProfileList();
            }
        });
    }
}

