/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.File;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.ProfileSchedulerListener;
import net.sourceforge.fullsync.Synchronizer;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskGenerationListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.Util;
import net.sourceforge.fullsync.cli.Main;
import net.sourceforge.fullsync.schedule.SchedulerChangeListener;
import net.sourceforge.fullsync.ui.AboutDialog;
import net.sourceforge.fullsync.ui.ConnectionPage;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.ImportProfilesPage;
import net.sourceforge.fullsync.ui.ListViewProfileListComposite;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.NiceListViewProfileListComposite;
import net.sourceforge.fullsync.ui.PreferencesPage;
import net.sourceforge.fullsync.ui.ProfileDetailsTabbedPage;
import net.sourceforge.fullsync.ui.ProfileListComposite;
import net.sourceforge.fullsync.ui.ProfileListControlHandler;
import net.sourceforge.fullsync.ui.StatusLine;
import net.sourceforge.fullsync.ui.SystemStatusPage;
import net.sourceforge.fullsync.ui.TaskDecisionList;
import net.sourceforge.fullsync.ui.WelcomeScreen;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class MainWindow
extends Composite
implements ShellListener,
ProfileSchedulerListener,
ProfileListControlHandler,
TaskGenerationListener,
SchedulerChangeListener {
    private ToolItem toolItemNew;
    private Menu menuBarMainWindow;
    private StatusLine statusLine;
    private ToolItem toolItemRun;
    private ToolItem toolItemRunNonIter;
    private ToolItem toolItemDelete;
    private ToolItem toolItemEdit;
    private ToolItem toolItemScheduleIcon;
    private ToolItem toolItemScheduleStart;
    private ToolItem toolItemScheduleStop;
    private Composite profileListContainer;
    private ProfileListComposite profileList;
    private GuiController guiController;
    private String statusDelayString;
    public WelcomeScreen welcomeScreen;

    MainWindow(Composite parent, int style, GuiController initGuiController) {
        super(parent, style);
        this.guiController = initGuiController;
        this.initGUI();
        this.getShell().addShellListener((ShellListener)this);
        ProfileManager pm = this.guiController.getProfileManager();
        pm.addSchedulerListener(this);
        pm.addSchedulerChangeListener(this);
        this.guiController.getSynchronizer().getTaskGenerator().addTaskGenerationListener(this);
        this.schedulerStatusChanged(pm.isSchedulerEnabled());
    }

    private void initGUI() {
        try {
            this.setSize(600, 300);
            GridLayout thisLayout = new GridLayout();
            thisLayout.horizontalSpacing = 0;
            thisLayout.marginHeight = 0;
            thisLayout.marginWidth = 0;
            thisLayout.verticalSpacing = 0;
            this.setLayout((Layout)thisLayout);
            this.menuBarMainWindow = new Menu((Decorations)this.getShell(), 2);
            this.getShell().setMenuBar(this.menuBarMainWindow);
            Composite cToolBar = new Composite((Composite)this, 4);
            GridLayout toolBarLayout = new GridLayout(2, false);
            toolBarLayout.marginHeight = 0;
            toolBarLayout.marginWidth = 0;
            toolBarLayout.horizontalSpacing = 0;
            toolBarLayout.verticalSpacing = 0;
            cToolBar.setLayout((Layout)toolBarLayout);
            ToolBar toolBarProfile = new ToolBar(cToolBar, 0x800000);
            this.toolItemNew = new ToolItem(toolBarProfile, 8);
            this.toolItemNew.setImage(this.guiController.getImage("Button_New.png"));
            this.toolItemNew.setToolTipText(Messages.getString("MainWindow.New_Profile"));
            this.toolItemNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.createNewProfile();
                }
            });
            this.toolItemEdit = new ToolItem(toolBarProfile, 8);
            this.toolItemEdit.setImage(this.guiController.getImage("Button_Edit.png"));
            this.toolItemEdit.setToolTipText(Messages.getString("MainWindow.Edit_Profile"));
            this.toolItemEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.editProfile(MainWindow.this.profileList.getSelectedProfile());
                }
            });
            this.toolItemDelete = new ToolItem(toolBarProfile, 8);
            this.toolItemDelete.setImage(this.guiController.getImage("Button_Delete.png"));
            this.toolItemDelete.setToolTipText(Messages.getString("MainWindow.Delete_Profile"));
            this.toolItemDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.deleteProfile(MainWindow.this.profileList.getSelectedProfile());
                }
            });
            this.toolItemRun = new ToolItem(toolBarProfile, 8);
            this.toolItemRun.setImage(this.guiController.getImage("Button_Run.png"));
            this.toolItemRun.setToolTipText(Messages.getString("MainWindow.Run_Profile"));
            this.toolItemRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), true);
                }
            });
            this.toolItemRunNonIter = new ToolItem(toolBarProfile, 8);
            this.toolItemRunNonIter.setImage(this.guiController.getImage("Button_Run_Non_Inter.png"));
            this.toolItemRunNonIter.setToolTipText("Run Profile - Non Interactive mode");
            this.toolItemRunNonIter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), false);
                }
            });
            ToolBar toolBarScheduling = new ToolBar(cToolBar, 0x800000);
            new ToolItem(toolBarScheduling, 2);
            this.toolItemScheduleIcon = new ToolItem(toolBarScheduling, 0);
            this.toolItemScheduleIcon.setImage(this.guiController.getImage("Scheduler_Icon.png"));
            this.toolItemScheduleIcon.setDisabledImage(this.guiController.getImage("Scheduler_Icon.png"));
            this.toolItemScheduleIcon.setEnabled(false);
            this.toolItemScheduleStart = new ToolItem(toolBarScheduling, 0);
            this.toolItemScheduleStart.setToolTipText(Messages.getString("MainWindow.Start_Scheduler"));
            this.toolItemScheduleStart.setImage(this.guiController.getImage("Scheduler_Start.png"));
            this.toolItemScheduleStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.guiController.getProfileManager().startScheduler();
                }
            });
            this.toolItemScheduleStop = new ToolItem(toolBarScheduling, 8);
            this.toolItemScheduleStop.setToolTipText(Messages.getString("MainWindow.Stop_Scheduler"));
            this.toolItemScheduleStop.setImage(this.guiController.getImage("Scheduler_Stop.png"));
            this.toolItemScheduleStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainWindow.this.guiController.getProfileManager().stopScheduler();
                }
            });
            this.profileListContainer = new Composite((Composite)this, 0);
            this.profileListContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            this.profileListContainer.setLayout((Layout)new FillLayout());
            this.statusLine = new StatusLine(this, 0);
            this.statusLine.setLayoutData(new GridData(4, 0x1000000, true, false));
            this.createMenu();
            this.createProfileList();
            this.layout();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    private void createMenu() {
        MenuItem menuItemFile = new MenuItem(this.menuBarMainWindow, 64);
        menuItemFile.setText(Messages.getString("MainWindow.File_Menu"));
        Menu menuFile = new Menu(menuItemFile);
        menuItemFile.setMenu(menuFile);
        MenuItem menuItemNewProfile = new MenuItem(menuFile, 8);
        menuItemNewProfile.setText(Messages.getString("MainWindow.New_Profile_Menu"));
        menuItemNewProfile.setImage(this.guiController.getImage("Button_New.png"));
        menuItemNewProfile.setAccelerator(262222);
        menuItemNewProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.createNewProfile();
            }
        });
        new MenuItem(menuFile, 2);
        MenuItem menuItemEditProfile = new MenuItem(menuFile, 8);
        menuItemEditProfile.setText(Messages.getString("MainWindow.Edit_Profile_Menu"));
        menuItemEditProfile.setImage(this.guiController.getImage("Button_Edit.png"));
        menuItemEditProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.editProfile(MainWindow.this.profileList.getSelectedProfile());
            }
        });
        MenuItem menuItemRunProfile = new MenuItem(menuFile, 8);
        menuItemRunProfile.setText(Messages.getString("MainWindow.Run_Profile_Menu"));
        menuItemRunProfile.setImage(this.guiController.getImage("Button_Run.png"));
        menuItemRunProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), true);
            }
        });
        MenuItem menuItemRunProfileNonInter = new MenuItem(menuFile, 8);
        menuItemRunProfileNonInter.setText("Run Profile - Non Interactive mode");
        menuItemRunProfileNonInter.setImage(this.guiController.getImage("Button_Run_Non_Inter.png"));
        menuItemRunProfileNonInter.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), false);
            }
        });
        new MenuItem(menuFile, 2);
        MenuItem menuItemDeleteProfile = new MenuItem(menuFile, 8);
        menuItemDeleteProfile.setText(Messages.getString("MainWindow.Delete_Profile_Menu"));
        menuItemDeleteProfile.setImage(this.guiController.getImage("Button_Delete.png"));
        menuItemDeleteProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.deleteProfile(MainWindow.this.profileList.getSelectedProfile());
            }
        });
        new MenuItem(menuFile, 2);
        MenuItem menuItemExitProfile = new MenuItem(menuFile, 8);
        menuItemExitProfile.setText(Messages.getString("MainWindow.Exit_Menu"));
        menuItemExitProfile.setAccelerator(262225);
        menuItemExitProfile.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.guiController.closeGui();
                    }
                });
            }
        });
        MenuItem menuItemEdit = new MenuItem(this.menuBarMainWindow, 64);
        menuItemEdit.setText(Messages.getString("MainWindow.Edit_Menu"));
        Menu menuEdit = new Menu(menuItemEdit);
        menuItemEdit.setMenu(menuEdit);
        MenuItem logItem = new MenuItem(menuEdit, 8);
        logItem.setText(Messages.getString("MainWindow.Show_Log_Menu"));
        logItem.setAccelerator(393292);
        logItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GuiController.launchProgram(new File(Main.getConfigDir() + "fullsync.log").getAbsolutePath());
            }
        });
        MenuItem preferencesItem = new MenuItem(menuEdit, 8);
        preferencesItem.setText(Messages.getString("MainWindow.Preferences_Menu"));
        preferencesItem.setAccelerator(393296);
        preferencesItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PreferencesPage dialog = new PreferencesPage(MainWindow.this.getShell(), MainWindow.this.guiController.getPreferences());
                dialog.show();
            }
        });
        MenuItem importItem = new MenuItem(menuEdit, 8);
        importItem.setText(Messages.getString("MainWindow.Import_Menu"));
        importItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ImportProfilesPage dialog = new ImportProfilesPage(MainWindow.this.getShell());
                dialog.show();
            }
        });
        MenuItem menuItemRemoteConnection = new MenuItem(this.menuBarMainWindow, 64);
        menuItemRemoteConnection.setText(Messages.getString("MainWindow.Remote_Connection_Menu"));
        Menu menuRemoteConnection = new Menu(menuItemRemoteConnection);
        menuItemRemoteConnection.setMenu(menuRemoteConnection);
        final MenuItem connectItem = new MenuItem(menuRemoteConnection, 8);
        connectItem.setText(Messages.getString("MainWindow.Connect_Menu"));
        connectItem.setAccelerator(393283);
        connectItem.setEnabled(true);
        final MenuItem disconnectItem = new MenuItem(menuRemoteConnection, 8);
        disconnectItem.setText(Messages.getString("MainWindow.Disconnect_Menu"));
        disconnectItem.setAccelerator(393284);
        disconnectItem.setEnabled(false);
        connectItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ConnectionPage dialog = new ConnectionPage(MainWindow.this.getShell());
                dialog.show();
                GuiController gc = GuiController.getInstance();
                if (gc.getProfileManager().isConnected()) {
                    connectItem.setEnabled(false);
                    disconnectItem.setEnabled(true);
                    gc.getMainShell().setImage(gc.getImage("Remote_Connect.png"));
                }
            }
        });
        disconnectItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MessageBox mb = new MessageBox(MainWindow.this.getShell(), 200);
                mb.setText(Messages.getString("MainWindow.Confirmation"));
                mb.setMessage(Messages.getString("MainWindow.Do_You_Want_To_Disconnect") + " \n");
                if (mb.open() == 64) {
                    GuiController gc = GuiController.getInstance();
                    gc.getProfileManager().disconnectRemote();
                    gc.getSynchronizer().disconnectRemote();
                    connectItem.setEnabled(true);
                    disconnectItem.setEnabled(false);
                    gc.getMainShell().setImage(gc.getImage("fullsync48.png"));
                }
            }
        });
        MenuItem menuItemHelp = new MenuItem(this.menuBarMainWindow, 64);
        menuItemHelp.setText(Messages.getString("MainWindow.Help_Menu"));
        Menu menuHelp = new Menu(menuItemHelp);
        menuItemHelp.setMenu(menuHelp);
        MenuItem menuItemHelpContent = new MenuItem(menuHelp, 8);
        menuItemHelpContent.setText(Messages.getString("MainWindow.Help_Menu_Item"));
        menuItemHelpContent.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                File helpIndex = new File("docs/manual/manual.html").getAbsoluteFile();
                if (helpIndex.exists()) {
                    GuiController.launchProgram(helpIndex.getAbsolutePath());
                } else {
                    GuiController.launchProgram(Util.getWebsiteURL() + "docs/manual-" + Util.getFullSyncVersion() + "/manual.html");
                }
            }
        });
        MenuItem menuItemTwitter = new MenuItem(menuHelp, 8);
        menuItemTwitter.setImage(this.guiController.getImage("twitter_bird_blue_16.png"));
        menuItemTwitter.setText(Messages.getString("MainWindow.Menu_Twitter"));
        menuItemTwitter.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                GuiController.launchProgram(Util.getTwitterURL());
            }
        });
        new MenuItem(menuHelp, 2);
        MenuItem menuItemSystem = new MenuItem(menuHelp, 8);
        menuItemSystem.setText(Messages.getString("MainWindow.Menu_SystemInfo"));
        menuItemSystem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SystemStatusPage dialog = new SystemStatusPage(MainWindow.this.getShell());
                dialog.show();
            }
        });
        new MenuItem(menuHelp, 2);
        MenuItem menuItemAbout = new MenuItem(menuHelp, 8);
        menuItemAbout.setAccelerator(262209);
        menuItemAbout.setText(Messages.getString("MainWindow.About_Menu"));
        menuItemAbout.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                new AboutDialog(MainWindow.this.getShell(), 0);
            }
        });
    }

    private Menu createPopupMenu() {
        Menu profilePopupMenu = new Menu((Decorations)this.getShell(), 8);
        MenuItem runItem = new MenuItem(profilePopupMenu, 8);
        runItem.setText(Messages.getString("MainWindow.Run_Profile"));
        runItem.setImage(this.guiController.getImage("Button_Run.png"));
        runItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), true);
            }
        });
        MenuItem runNonInterItem = new MenuItem(profilePopupMenu, 8);
        runNonInterItem.setText("Run Profile - Non Interactive mode");
        runNonInterItem.setImage(this.guiController.getImage("Button_Run_Non_Inter.png"));
        runNonInterItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.runProfile(MainWindow.this.profileList.getSelectedProfile(), false);
            }
        });
        MenuItem editItem = new MenuItem(profilePopupMenu, 8);
        editItem.setText(Messages.getString("MainWindow.Edit_Profile"));
        editItem.setImage(this.guiController.getImage("Button_Edit.png"));
        editItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.editProfile(MainWindow.this.profileList.getSelectedProfile());
            }
        });
        MenuItem deleteItem = new MenuItem(profilePopupMenu, 8);
        deleteItem.setText(Messages.getString("MainWindow.Delete_Profile"));
        deleteItem.setImage(this.guiController.getImage("Button_Delete.png"));
        deleteItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.deleteProfile(MainWindow.this.profileList.getSelectedProfile());
            }
        });
        new MenuItem(profilePopupMenu, 2);
        MenuItem addItem = new MenuItem(profilePopupMenu, 8);
        addItem.setText(Messages.getString("MainWindow.New_Profile"));
        addItem.setImage(this.guiController.getImage("Button_New.png"));
        addItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MainWindow.this.createNewProfile();
            }
        });
        return profilePopupMenu;
    }

    void createProfileList() {
        for (Control c : this.profileListContainer.getChildren()) {
            c.dispose();
        }
        this.profileList = "NiceListView".equals(this.guiController.getPreferences().getProfileListStyle()) ? new NiceListViewProfileListComposite(this.profileListContainer, 0) : new ListViewProfileListComposite(this.profileListContainer, 0);
        this.profileList.setMenu(this.createPopupMenu());
        this.profileList.setHandler(this);
        this.profileList.setProfileManager(this.guiController.getProfileManager());
        this.profileListContainer.layout();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public GuiController getGuiController() {
        return this.guiController;
    }

    private void minimizeToTray() {
        this.getShell().setMinimized(true);
        this.getShell().setVisible(false);
    }

    @Override
    public void schedulerStatusChanged(final boolean enabled) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.toolItemScheduleStart.setEnabled(!enabled);
                MainWindow.this.toolItemScheduleStop.setEnabled(enabled);
            }
        });
    }

    @Override
    public void taskTreeStarted(TaskTree tree) {
    }

    @Override
    public void taskGenerationStarted(net.sourceforge.fullsync.fs.File source, net.sourceforge.fullsync.fs.File destination) {
        this.statusDelayString = Messages.getString("MainWindow.Checking_File", source.getPath());
    }

    @Override
    public void taskGenerationFinished(Task task) {
    }

    @Override
    public void taskTreeFinished(TaskTree tree) {
        this.statusLine.setMessage(Messages.getString("MainWindow.Sync_Finished"));
    }

    @Override
    public void profileExecutionScheduled(Profile profile) {
        Synchronizer sync = this.guiController.getSynchronizer();
        TaskTree tree = sync.executeProfile(profile, false);
        if (tree == null) {
            profile.setLastError(1, Messages.getString("MainWindow.Error_Comparing_Filesystems"));
        } else {
            int errorLevel = sync.performActions(tree);
            if (errorLevel > 0) {
                profile.setLastError(errorLevel, Messages.getString("MainWindow.Error_Copying_Files"));
            } else {
                profile.beginUpdate();
                profile.setLastError(0, null);
                profile.setLastUpdate(new Date());
                profile.endUpdate();
            }
        }
    }

    @Override
    public void createNewProfile() {
        try {
            ProfileDetailsTabbedPage dialog = new ProfileDetailsTabbedPage(this.getShell(), this.guiController.getProfileManager(), null);
            dialog.show();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public void runProfile(final Profile p, final boolean interactive) {
        if (p == null) {
            return;
        }
        if (!interactive) {
            MessageBox mb = new MessageBox(this.getShell(), 196);
            mb.setText(Messages.getString("MainWindow.Confirmation"));
            mb.setMessage("You're about to start the profile in non-interactive mode.\n Are you sure?");
            if (mb.open() != 64) {
                return;
            }
        }
        Thread worker = new Thread(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.doRunProfile(p, interactive);
            }
        });
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doRunProfile(Profile p, boolean interactive) {
        TaskTree t = null;
        Timer statusDelayTimer = null;
        try {
            this.guiController.showBusyCursor(true);
            statusDelayTimer = new Timer(true);
            try {
                statusDelayTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        MainWindow.this.statusLine.setMessage(MainWindow.this.statusDelayString);
                    }
                }, 10L, 100L);
                this.statusDelayString = Messages.getString("MainWindow.Starting_Profile") + p.getName() + "...";
                this.statusLine.setMessage(this.statusDelayString);
                t = this.guiController.getSynchronizer().executeProfile(p, interactive);
                if (t == null) {
                    p.setLastError(1, Messages.getString("MainWindow.Error_Comparing_Filesystems"));
                    this.statusLine.setMessage(Messages.getString("MainWindow.Error_Processing_Profile", p.getName()));
                } else {
                    this.statusLine.setMessage(Messages.getString("MainWindow.Finished_Profile", p.getName()));
                }
            }
            catch (Error e) {
                ExceptionHandler.reportException(e);
            }
            finally {
                statusDelayTimer.cancel();
                this.guiController.showBusyCursor(false);
            }
            if (t != null) {
                TaskDecisionList.show(this.guiController, p, t, interactive);
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public void editProfile(Profile p) {
        if (p == null) {
            return;
        }
        try {
            ProfileDetailsTabbedPage dialog = new ProfileDetailsTabbedPage(this.getShell(), this.guiController.getProfileManager(), p);
            dialog.show();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    @Override
    public void deleteProfile(Profile p) {
        if (p != null) {
            ProfileManager profileManager = this.guiController.getProfileManager();
            MessageBox mb = new MessageBox(this.getShell(), 196);
            mb.setText(Messages.getString("MainWindow.Confirmation"));
            mb.setMessage(Messages.getString("MainWindow.Do_You_Want_To_Delete_Profile") + " " + p.getName() + " ?");
            if (mb.open() == 64) {
                profileManager.removeProfile(p);
                profileManager.save();
            }
        }
    }

    protected void toolItemScheduleWidgedSelected(SelectionEvent evt) {
        ProfileManager profileManager = this.guiController.getProfileManager();
        if (profileManager.isSchedulerEnabled()) {
            profileManager.stopScheduler();
        } else {
            profileManager.startScheduler();
        }
    }

    public void shellActivated(ShellEvent e) {
    }

    public void shellClosed(ShellEvent e) {
        e.doit = false;
        if (this.guiController.getPreferences().closeMinimizesToSystemTray()) {
            this.minimizeToTray();
        } else {
            this.guiController.closeGui();
        }
    }

    public void shellDeactivated(ShellEvent e) {
    }

    public void shellDeiconified(ShellEvent e) {
    }

    public void shellIconified(ShellEvent e) {
        if (this.guiController.getPreferences().minimizeMinimizesToSystemTray()) {
            e.doit = false;
            this.minimizeToTray();
        } else {
            e.doit = true;
        }
    }
}

