/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.GuiController;

public class Messages {
    private static final String BUNDLE_NAME = "net.sourceforge.fullsync.ui.messages";
    private ResourceBundle RESOURCE_BUNDLE;
    private static Messages instance;

    private Messages() {
        String code = GuiController.getInstance().getPreferences().getLanguageCode();
        Locale langLocale = new Locale(code);
        try {
            Locale.setDefault(langLocale);
            this.RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME, langLocale);
        }
        catch (Throwable e) {
            ExceptionHandler.reportException("Unable to find locale for language " + code, e);
            this.RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
        }
    }

    public static String getString(String key) {
        String value = '!' + key + '!';
        if (instance == null) {
            instance = new Messages();
        }
        try {
            value = Messages.instance.RESOURCE_BUNDLE.getString(key);
            if (null != value && value.length() > 0) {
                return value;
            }
            value = '!' + key + '!';
            throw new Exception("WARNING: Translation for message '" + key + "' missing!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }

    public static String getString(String key, String value) {
        String msg = Messages.getString(key);
        return MessageFormat.format(msg, value);
    }
}

