/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.Arrays;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.ui.NiceListViewItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class NiceListView
extends Composite
implements Listener {
    private Color colorDefault = this.getDisplay().getSystemColor(25);
    private Color colorHover = this.getDisplay().getSystemColor(19);
    private Color colorSelected = this.getDisplay().getSystemColor(26);
    private Color colorForeground = this.getDisplay().getSystemColor(24);
    private Color colorSelectedForegroud = this.getDisplay().getSystemColor(27);
    private NiceListViewItem selected;

    public NiceListView(Composite parent, int style) {
        super(parent, style);
        this.addListener(1, this);
        this.initGUI();
    }

    public Color getColorDefault() {
        return this.colorDefault;
    }

    public Color getColorHover() {
        return this.colorHover;
    }

    public Color getColorSelected() {
        return this.colorSelected;
    }

    public Color getColorForeground() {
        return this.colorForeground;
    }

    public Color getColorSelectedForegroud() {
        return this.colorSelectedForegroud;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: {
                Control[] children = this.getChildren();
                int index = Arrays.asList(children).indexOf((Object)this.selected);
                switch (event.keyCode) {
                    case 0x1000001: {
                        if (index <= 0) break;
                        --index;
                        break;
                    }
                    case 0x1000002: {
                        if (index + 1 >= children.length) break;
                        ++index;
                        break;
                    }
                    case 0x1000007: {
                        if (children.length <= 0) break;
                        index = 0;
                        break;
                    }
                    case 0x1000008: {
                        if (children.length <= 0) break;
                        index = children.length - 1;
                        break;
                    }
                    case 0x1000005: {
                        index = Math.max(0, index - 5);
                        break;
                    }
                    case 0x1000006: {
                        index = Math.min(children.length - 1, index + 5);
                        break;
                    }
                    default: {
                        index = -1;
                    }
                }
                if (index <= -1) break;
                this.setSelected((NiceListViewItem)children[index]);
                Composite parent = this.getParent();
                if (!(parent instanceof ScrolledComposite)) break;
                ScrolledComposite sc = (ScrolledComposite)parent;
                sc.showControl(children[index]);
                break;
            }
        }
    }

    private void initGUI() {
        try {
            GridLayout thisLayout = new GridLayout();
            thisLayout.horizontalSpacing = 2;
            thisLayout.verticalSpacing = 0;
            this.setLayout((Layout)thisLayout);
            this.setBackground(this.getDisplay().getSystemColor(25));
            this.layout();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    public Composite getSelectedContent() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getContent();
    }

    public void setSelected(NiceListViewItem item) {
        Control[] children;
        if (item == this.selected) {
            this.selected.forceFocus();
            return;
        }
        for (Control element : children = this.getChildren()) {
            NiceListViewItem a = (NiceListViewItem)element;
            a.setSelected(false);
        }
        item.setSelected(true);
        this.selected = item;
        this.setSize(this.computeSize(-1, -1));
        this.layout();
    }

    public boolean setFocus() {
        if (this.selected != null) {
            this.selected.forceFocus();
            return true;
        }
        Control[] cs = this.getChildren();
        if (cs.length > 0) {
            cs[0].forceFocus();
            return true;
        }
        return false;
    }

    public void clear() {
        Control[] children;
        for (Control element : children = this.getChildren()) {
            element.dispose();
        }
    }
}

