/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.NiceListView;
import net.sourceforge.fullsync.ui.ProfileListControlHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class NiceListViewItem
extends Canvas
implements Listener {
    private NiceListView parent;
    private Label labelIcon;
    private Label labelCaption;
    private Label labelStatus;
    private Composite compositeContent;
    private ProfileListControlHandler handler;
    private Profile profile;
    private boolean mouseOver;
    private boolean selected;

    public NiceListViewItem(NiceListView parent, int style) {
        super((Composite)parent, style);
        this.parent = parent;
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.setLayoutData(layoutData);
        GridLayout thisLayout = new GridLayout();
        this.addListener(6, this);
        this.addListener(7, this);
        this.addListener(4, this);
        this.addListener(3, this);
        this.addListener(8, this);
        this.addListener(1, this);
        this.addListener(15, this);
        this.addListener(16, this);
        this.setLayout((Layout)thisLayout);
        thisLayout.numColumns = 3;
        thisLayout.marginHeight = 3;
        thisLayout.marginWidth = 3;
        this.labelIcon = new Label((Composite)this, 0x40000000);
        this.labelIcon.setSize(16, 16);
        GridData labelIconLData = new GridData();
        labelIconLData.grabExcessVerticalSpace = true;
        labelIconLData.verticalAlignment = 1;
        labelIconLData.widthHint = 16;
        labelIconLData.heightHint = 16;
        this.labelIcon.setLayoutData((Object)labelIconLData);
        this.labelIcon.addListener(6, (Listener)this);
        this.labelIcon.addListener(7, (Listener)this);
        this.labelIcon.addListener(4, (Listener)this);
        this.labelIcon.addListener(3, (Listener)this);
        this.labelIcon.addListener(8, (Listener)this);
        this.labelCaption = new Label((Composite)this, 0x40000000);
        this.labelCaption.setFont(GuiController.getInstance().getFont("Tahoma", 9, 1));
        GridData labelCaptionLData = new GridData();
        labelCaptionLData.widthHint = -1;
        this.labelCaption.setLayoutData((Object)labelCaptionLData);
        this.labelCaption.addListener(6, (Listener)this);
        this.labelCaption.addListener(7, (Listener)this);
        this.labelCaption.addListener(4, (Listener)this);
        this.labelCaption.addListener(3, (Listener)this);
        this.labelCaption.addListener(8, (Listener)this);
        this.labelStatus = new Label((Composite)this, 0x40000000);
        GridData labelStatusLData = new GridData();
        labelStatusLData.grabExcessHorizontalSpace = true;
        labelStatusLData.horizontalAlignment = 4;
        labelStatusLData.horizontalIndent = 10;
        this.labelStatus.setLayoutData((Object)labelStatusLData);
        this.labelStatus.addListener(6, (Listener)this);
        this.labelStatus.addListener(7, (Listener)this);
        this.labelStatus.addListener(4, (Listener)this);
        this.labelStatus.addListener(3, (Listener)this);
        this.labelStatus.addListener(8, (Listener)this);
        this.setBackground(parent.getColorDefault());
        this.setForeground(parent.getForeground());
        this.layout();
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 6: {
                this.mouseOver = true;
                this.updateBackground();
                break;
            }
            case 7: {
                this.mouseOver = false;
                this.updateBackground();
                break;
            }
            case 3: {
                this.parent.setSelected(this);
                break;
            }
            case 4: {
                if (event.button != 3) break;
                this.getMenu().setVisible(true);
                break;
            }
            case 8: {
                this.handler.editProfile(this.profile);
                break;
            }
            case 1: {
                this.parent.handleEvent(event);
                break;
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (Control element : this.getChildren()) {
            element.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (Control element : this.getChildren()) {
            element.setForeground(color);
        }
    }

    public void updateBackground() {
        if (this.selected) {
            this.setBackground(this.parent.getColorSelected());
        } else {
            this.setBackground(this.mouseOver ? this.parent.getColorHover() : this.parent.getColorDefault());
        }
        this.setForeground(this.selected ? this.parent.getColorSelectedForegroud() : this.parent.getColorForeground());
    }

    public void setImage(Image image) {
        this.labelIcon.setImage(image);
    }

    public void setText(String text) {
        this.labelCaption.setText(text);
        this.labelCaption.pack();
        this.layout();
    }

    public void setStatusText(String status) {
        if (status == null || status.length() == 0) {
            this.labelStatus.setText("");
        } else {
            this.labelStatus.setText("(" + status + ")");
        }
        this.labelStatus.pack();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.forceFocus();
            this.compositeContent.setVisible(true);
            Point size = this.compositeContent.computeSize(-1, -1);
            ((GridData)this.compositeContent.getLayoutData()).widthHint = size.x;
            ((GridData)this.compositeContent.getLayoutData()).heightHint = size.y;
        } else {
            this.compositeContent.setVisible(false);
            ((GridData)this.compositeContent.getLayoutData()).widthHint = 0;
            ((GridData)this.compositeContent.getLayoutData()).heightHint = 0;
        }
        this.selected = selected;
        this.updateBackground();
        this.layout();
    }

    public Composite getContent() {
        return this.compositeContent;
    }

    public void setContent(Composite content) {
        Control[] children;
        this.compositeContent = content;
        GridData compositeContentLData = new GridData();
        compositeContentLData.horizontalSpan = 3;
        compositeContentLData.horizontalIndent = this.labelIcon.getBounds().width + 4;
        compositeContentLData.grabExcessHorizontalSpace = true;
        compositeContentLData.horizontalAlignment = 4;
        compositeContentLData.heightHint = 0;
        compositeContentLData.widthHint = 0;
        this.compositeContent.setLayoutData((Object)compositeContentLData);
        this.compositeContent.setVisible(false);
        this.compositeContent.addListener(8, (Listener)this);
        this.compositeContent.addListener(4, (Listener)this);
        this.compositeContent.addListener(3, (Listener)this);
        for (Control element : children = this.compositeContent.getChildren()) {
            element.addListener(8, (Listener)this);
            element.addListener(4, (Listener)this);
            element.addListener(3, (Listener)this);
        }
    }

    public ProfileListControlHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ProfileListControlHandler handler) {
        this.handler = handler;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }
}

