/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.HashMap;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileListChangeListener;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.NiceListView;
import net.sourceforge.fullsync.ui.NiceListViewItem;
import net.sourceforge.fullsync.ui.ProfileListComposite;
import net.sourceforge.fullsync.ui.ProfileListControlHandler;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class NiceListViewProfileListComposite
extends ProfileListComposite
implements ProfileListChangeListener {
    private ScrolledComposite scrollPane;
    private NiceListView profileList;
    private HashMap<Profile, NiceListViewItem> profilesToItems;
    private ProfileManager profileManager;
    private ProfileListControlHandler handler;
    private Image imageProfileDefault;
    private Image imageProfileScheduled;
    private Image imageProfileError;
    private Image imageProfileErrorScheduled;
    private Image imageRun;
    private Image imageRunNonInter;
    private Image imageEdit;
    private Image imageDelete;

    public NiceListViewProfileListComposite(Composite parent, int style) {
        super(parent, style);
        this.loadImages();
        this.scrollPane = new ScrolledComposite((Composite)this, 2560);
        this.profileList = new NiceListView((Composite)this.scrollPane, 0x40000000);
        this.scrollPane.setExpandHorizontal(true);
        this.scrollPane.setExpandVertical(false);
        this.scrollPane.setAlwaysShowScrollBars(true);
        this.scrollPane.setContent((Control)this.profileList);
        this.scrollPane.setBackground(this.getDisplay().getSystemColor(25));
        this.scrollPane.getVerticalBar().setIncrement(20);
        this.profileList.pack();
        this.setLayout((Layout)new FillLayout());
        this.layout();
    }

    private void loadImages() {
        GuiController gc = GuiController.getInstance();
        this.imageProfileDefault = gc.getImage("Profile_Default.png");
        this.imageProfileScheduled = gc.getImage("Profile_Default_Scheduled.png");
        this.imageProfileError = gc.getImage("Profile_Default_Error.png");
        this.imageProfileErrorScheduled = gc.getImage("Profile_Default_Error_Scheduled.png");
        this.imageRun = gc.getImage("Profile_Run.png");
        this.imageRunNonInter = gc.getImage("Profile_Run_Non_Inter.png");
        this.imageEdit = gc.getImage("Profile_Edit.png");
        this.imageDelete = gc.getImage("Profile_Delete.png");
    }

    public void dispose() {
        this.profileManager.removeProfilesChangeListener(this);
        super.dispose();
    }

    private void updateItem(NiceListViewItem item, Profile profile) {
        if (profile.isEnabled() && profile.getSchedule() != null) {
            if (profile.getLastErrorLevel() > 0) {
                item.setImage(this.imageProfileErrorScheduled);
            } else {
                item.setImage(this.imageProfileScheduled);
            }
        } else if (profile.getLastErrorLevel() > 0) {
            item.setImage(this.imageProfileError);
        } else {
            item.setImage(this.imageProfileDefault);
        }
        item.setText(profile.getName());
        if (profile.getLastErrorLevel() > 0) {
            item.setStatusText(profile.getLastErrorString());
        } else {
            String desc = profile.getDescription();
            if (desc != null && !"".equals(desc)) {
                item.setStatusText(desc);
            } else if (profile.isEnabled() && profile.getSchedule() != null) {
                item.setStatusText(profile.getNextUpdateText());
            } else {
                item.setStatusText("");
            }
        }
    }

    private void populateProfileList() {
        if (this.getProfileManager() != null) {
            this.profilesToItems = new HashMap();
            this.setItemsMenu(null);
            this.profileList.clear();
            for (Profile p : this.getProfileManager().getProfiles()) {
                NiceListViewItem item = null;
                try {
                    item = new NiceListViewItem(this.profileList, 0);
                    ContentComposite content = new ContentComposite((Composite)item, 0);
                    content.setProfile(p);
                    item.setContent(content);
                    item.setMenu(this.getMenu());
                    item.setHandler(this.handler);
                    item.setProfile(p);
                    this.updateItem(item, p);
                    this.profilesToItems.put(p, item);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (item == null) continue;
                    item.dispose();
                }
            }
            this.profileList.pack();
        }
    }

    @Override
    public Profile getSelectedProfile() {
        ContentComposite content = (ContentComposite)this.profileList.getSelectedContent();
        if (content != null) {
            return content.getProfile();
        }
        return null;
    }

    @Override
    public void setProfileManager(ProfileManager profileManager) {
        if (this.profileManager != null) {
            profileManager.removeProfilesChangeListener(this);
        }
        this.profileManager = profileManager;
        if (this.profileManager != null) {
            profileManager.addProfilesChangeListener(this);
        }
        this.populateProfileList();
    }

    @Override
    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    @Override
    public ProfileListControlHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(ProfileListControlHandler handler) {
        this.handler = handler;
    }

    public void setItemsMenu(Menu menu) {
        for (Control item : this.profileList.getChildren()) {
            item.setMenu(menu);
        }
    }

    public void setMenu(Menu menu) {
        this.setItemsMenu(menu);
        super.setMenu(menu);
    }

    @Override
    public void profileListChanged() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                NiceListViewProfileListComposite.this.populateProfileList();
            }
        });
    }

    @Override
    public void profileChanged(final Profile p) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Object composite = NiceListViewProfileListComposite.this.profilesToItems.get(p);
                if (composite == null) {
                    NiceListViewProfileListComposite.this.populateProfileList();
                } else {
                    NiceListViewItem item = (NiceListViewItem)((Object)composite);
                    ContentComposite content = (ContentComposite)item.getContent();
                    NiceListViewProfileListComposite.this.updateItem(item, content.getProfile());
                    content.updateComponent();
                }
            }
        });
    }

    class ContentComposite
    extends Composite {
        private Profile profile;
        private Label lSource;
        private Label lDestination;
        private Label lLastUpdate;
        private Label lNextUpdate;

        public ContentComposite(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 1;
            layout.marginWidth = 1;
            layout.verticalSpacing = 2;
            layout.horizontalSpacing = 2;
            this.setLayout((Layout)layout);
            Composite cSourceDestination = new Composite((Composite)this, 4);
            GridLayout sourceDestinationLayout = new GridLayout(2, false);
            sourceDestinationLayout.marginHeight = 0;
            sourceDestinationLayout.marginWidth = 0;
            cSourceDestination.setLayout((Layout)sourceDestinationLayout);
            GridData cSourceDestinationData = new GridData(4, 0x1000000, true, false);
            cSourceDestinationData.horizontalSpan = 2;
            cSourceDestination.setLayoutData((Object)cSourceDestinationData);
            cSourceDestination.setBackgroundMode(1);
            cSourceDestination.setEnabled(false);
            Label labelSource = new Label(cSourceDestination, 0);
            labelSource.setText(Messages.getString("NiceListViewProfileListComposite.Source") + ":");
            this.lSource = new Label(cSourceDestination, 0);
            GridData lSourceData = new GridData(4, 0x1000000, true, false);
            this.lSource.setLayoutData((Object)lSourceData);
            Label labelDestination = new Label(cSourceDestination, 0);
            labelDestination.setText(Messages.getString("NiceListViewProfileListComposite.Destination") + ":");
            this.lDestination = new Label(cSourceDestination, 0);
            GridData lDestinationData = new GridData(4, 0x1000000, true, false);
            this.lDestination.setLayoutData((Object)lDestinationData);
            Composite cUpdate = new Composite((Composite)this, 4);
            GridLayout updateLayout = new GridLayout(2, false);
            updateLayout.marginHeight = 0;
            updateLayout.marginWidth = 0;
            cUpdate.setLayout((Layout)updateLayout);
            GridData cUpdateData = new GridData(4, 0x1000000, true, false);
            cUpdateData.grabExcessHorizontalSpace = true;
            cUpdateData.horizontalAlignment = 4;
            cUpdate.setLayoutData((Object)cUpdateData);
            cUpdate.setBackgroundMode(1);
            cUpdate.setEnabled(false);
            Label labelLastUpdate = new Label(cUpdate, 0);
            labelLastUpdate.setText(Messages.getString("NiceListViewProfileListComposite.LastUpdate") + ":");
            this.lLastUpdate = new Label(cUpdate, 0);
            this.lLastUpdate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label labelNextUpdate = new Label(cUpdate, 0);
            labelNextUpdate.setText(Messages.getString("NiceListViewProfileListComposite.NextUpdate") + ":");
            this.lNextUpdate = new Label(cUpdate, 0);
            this.lNextUpdate.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ToolBar toolbar = new ToolBar((Composite)this, 0x800000);
            GridData d = new GridData(0x1000008, 0x1000000, true, false);
            d.verticalSpan = 2;
            toolbar.setLayoutData((Object)d);
            ToolItem t = new ToolItem(toolbar, 8);
            t.setImage(NiceListViewProfileListComposite.this.imageRun);
            t.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NiceListViewProfileListComposite.this.handler.runProfile(ContentComposite.this.profile, true);
                }
            });
            t = new ToolItem(toolbar, 8);
            t.setImage(NiceListViewProfileListComposite.this.imageRunNonInter);
            t.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NiceListViewProfileListComposite.this.handler.runProfile(ContentComposite.this.profile, false);
                }
            });
            t = new ToolItem(toolbar, 8);
            t.setImage(NiceListViewProfileListComposite.this.imageEdit);
            t.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NiceListViewProfileListComposite.this.handler.editProfile(ContentComposite.this.profile);
                }
            });
            t = new ToolItem(toolbar, 8);
            t.setImage(NiceListViewProfileListComposite.this.imageDelete);
            t.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NiceListViewProfileListComposite.this.handler.deleteProfile(ContentComposite.this.profile);
                }
            });
        }

        public void updateComponent() {
            ConnectionDescription desc = this.profile.getSource();
            this.lSource.setText(null != desc ? desc.getDisplayPath() : "null");
            desc = this.profile.getDestination();
            this.lDestination.setText(null != desc ? desc.getDisplayPath() : "null");
            this.lLastUpdate.setText(this.profile.getLastUpdateText());
            this.lNextUpdate.setText(this.profile.getNextUpdateText());
            this.layout();
        }

        public void setProfile(Profile profile) {
            this.profile = profile;
            this.updateComponent();
        }

        public Profile getProfile() {
            return this.profile;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            for (Control c : this.getChildren()) {
                if (c instanceof Composite) {
                    for (Control child : ((Composite)c).getChildren()) {
                        child.setBackground(color);
                    }
                }
                c.setBackground(color);
            }
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            for (Control c : this.getChildren()) {
                if (c instanceof Composite) {
                    for (Control child : ((Composite)c).getChildren()) {
                        child.setForeground(color);
                    }
                }
                c.setForeground(color);
            }
        }
    }
}

