/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.rmi.RemoteException;
import java.util.Arrays;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Preferences;
import net.sourceforge.fullsync.remote.RemoteController;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreferencesPage
extends WizardDialog {
    private static String[] languageCodes = new String[]{"en", "it", "de", "fr", "es", "ar", "el"};
    private static String[] languageNames = new String[]{"English", "Italiano", "Deutsch", "Fran\u00e7ais", "Espa\u00f1ol", "Arabic", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac"};
    private Group groupInterface;
    private Button cbConfirmExit;
    private Button cbCloseMinimizesToSystemTray;
    private Button cbMinimizeMinimizesToSystemTray;
    private Combo comboLanguage;
    private Button cbAutostartScheduler;
    private Text textPassword;
    private Label labelPassword;
    private Group groupRemoteConnection;
    private Text textListeningPort;
    private Label labelPort;
    private Button cbListenForIncomming;
    private Combo comboProfileList;
    private Preferences preferences;

    private static String arraySearch(String[] in, String[] result, String key) {
        int i = 0;
        for (String s : in) {
            if (s.equals(key)) {
                return result[i];
            }
            ++i;
        }
        return "";
    }

    private static String getLanguageCode(String name) {
        return PreferencesPage.arraySearch(languageNames, languageCodes, name);
    }

    private static String getLanguageName(String code) {
        return PreferencesPage.arraySearch(languageCodes, languageNames, code);
    }

    public PreferencesPage(Shell parent, Preferences preferences) {
        super(parent);
        this.preferences = preferences;
    }

    @Override
    public String getTitle() {
        return Messages.getString("PreferencesPage.Preferences");
    }

    @Override
    public String getCaption() {
        return Messages.getString("PreferencesPage.Preferences");
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public void createContent(Composite content) {
        content.setLayout((Layout)new GridLayout());
        GridData thisLData = new GridData();
        thisLData.horizontalAlignment = 4;
        thisLData.grabExcessHorizontalSpace = true;
        thisLData.grabExcessVerticalSpace = true;
        content.setLayoutData((Object)thisLData);
        this.groupInterface = new Group(content, 4);
        GridLayout generalPreferencesGroupLayout = new GridLayout(2, false);
        GridData generalPreferencesGroupLData = new GridData();
        generalPreferencesGroupLData.grabExcessHorizontalSpace = true;
        generalPreferencesGroupLData.grabExcessVerticalSpace = true;
        generalPreferencesGroupLData.horizontalAlignment = 4;
        generalPreferencesGroupLData.verticalAlignment = 4;
        this.groupInterface.setLayoutData((Object)generalPreferencesGroupLData);
        this.groupInterface.setLayout((Layout)generalPreferencesGroupLayout);
        this.groupInterface.setText(Messages.getString("PreferencesComposite.Interface"));
        this.cbConfirmExit = new Button((Composite)this.groupInterface, 16416);
        this.cbConfirmExit.setText(Messages.getString("PreferencesComposite.ConfirmExit"));
        GridData askOnClosingCheckBoxLData = new GridData();
        askOnClosingCheckBoxLData.horizontalAlignment = 4;
        askOnClosingCheckBoxLData.horizontalSpan = 2;
        askOnClosingCheckBoxLData.grabExcessHorizontalSpace = true;
        this.cbConfirmExit.setLayoutData((Object)askOnClosingCheckBoxLData);
        this.cbCloseMinimizesToSystemTray = new Button((Composite)this.groupInterface, 16416);
        this.cbCloseMinimizesToSystemTray.setText(Messages.getString("PreferencesComposite.CloseMinimizes"));
        GridData closeButtonMinimizesCheckBoxLData = new GridData();
        closeButtonMinimizesCheckBoxLData.horizontalAlignment = 4;
        closeButtonMinimizesCheckBoxLData.horizontalSpan = 2;
        this.cbCloseMinimizesToSystemTray.setLayoutData((Object)closeButtonMinimizesCheckBoxLData);
        this.cbMinimizeMinimizesToSystemTray = new Button((Composite)this.groupInterface, 16416);
        this.cbMinimizeMinimizesToSystemTray.setText(Messages.getString("PreferencesComposite.MinimizeMinimizes"));
        GridData cbMinimizeMinimizesToSystemTrayLData = new GridData();
        cbMinimizeMinimizesToSystemTrayLData.horizontalAlignment = 4;
        cbMinimizeMinimizesToSystemTrayLData.horizontalSpan = 2;
        this.cbMinimizeMinimizesToSystemTray.setLayoutData((Object)cbMinimizeMinimizesToSystemTrayLData);
        this.cbAutostartScheduler = new Button((Composite)this.groupInterface, 16416);
        this.cbAutostartScheduler.setText(Messages.getString("PreferencesComposite.AutostartScheduler"));
        GridData cbAutostartSchedulerLData = new GridData();
        cbAutostartSchedulerLData.horizontalAlignment = 4;
        cbAutostartSchedulerLData.horizontalSpan = 2;
        this.cbAutostartScheduler.setLayoutData((Object)cbAutostartSchedulerLData);
        Label labelProfileListStyle = new Label((Composite)this.groupInterface, 0);
        labelProfileListStyle.setText(Messages.getString("PreferencesComposite.ProfileListStyle") + ": ");
        this.comboProfileList = new Combo((Composite)this.groupInterface, 12);
        GridData comboProfileListLData = new GridData();
        comboProfileListLData.horizontalAlignment = 4;
        this.comboProfileList.setLayoutData((Object)comboProfileListLData);
        this.comboProfileList.add(Messages.getString("PreferencesComposite.Table"));
        this.comboProfileList.add(Messages.getString("PreferencesComposite.NiceListView"));
        Label labelLanguage = new Label((Composite)this.groupInterface, 0);
        labelLanguage.setText(Messages.getString("PreferencesComposite.Language") + ":");
        this.comboLanguage = new Combo((Composite)this.groupInterface, 12);
        GridData comboLanguageLData = new GridData();
        comboLanguageLData.horizontalAlignment = 4;
        this.comboLanguage.setLayoutData((Object)comboLanguageLData);
        Object[] languages = new String[languageNames.length];
        System.arraycopy(languageNames, 0, languages, 0, languageNames.length);
        Arrays.sort(languages);
        for (Object language : languages) {
            this.comboLanguage.add((String)language);
        }
        new Label((Composite)this.groupInterface, 0);
        Label labelNeedsRestart = new Label((Composite)this.groupInterface, 0);
        labelNeedsRestart.setText(Messages.getString("PreferencesComposite.NeedsRestart"));
        GridData labelNeedsRestartLData = new GridData();
        labelNeedsRestartLData.horizontalAlignment = 4;
        labelNeedsRestart.setLayoutData((Object)labelNeedsRestartLData);
        this.groupRemoteConnection = new Group(content, 0);
        GridLayout groupRemoteConnectionLayout = new GridLayout();
        GridData groupRemoteConnectionLData = new GridData();
        groupRemoteConnectionLData.horizontalAlignment = 4;
        groupRemoteConnectionLData.grabExcessVerticalSpace = true;
        groupRemoteConnectionLData.verticalAlignment = 4;
        this.groupRemoteConnection.setLayoutData((Object)groupRemoteConnectionLData);
        groupRemoteConnectionLayout.numColumns = 2;
        this.groupRemoteConnection.setLayout((Layout)groupRemoteConnectionLayout);
        this.groupRemoteConnection.setText(Messages.getString("PreferencesComposite.RemoteConnection"));
        this.cbListenForIncomming = new Button((Composite)this.groupRemoteConnection, 16416);
        this.cbListenForIncomming.setText(Messages.getString("PreferencesComposite.EnableRemoteConnections"));
        GridData cbListenForIncommingLData = new GridData();
        this.cbListenForIncomming.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                PreferencesPage.this.updateRemoteConnectionGroup();
            }
        });
        cbListenForIncommingLData.horizontalSpan = 2;
        this.cbListenForIncomming.setLayoutData((Object)cbListenForIncommingLData);
        this.labelPort = new Label((Composite)this.groupRemoteConnection, 0);
        this.labelPort.setText(Messages.getString("PreferencesComposite.IncomingPort") + ":");
        this.labelPort.setEnabled(false);
        this.textListeningPort = new Text((Composite)this.groupRemoteConnection, 2048);
        this.textListeningPort.setText("10000");
        GridData textListeningPortLData = new GridData();
        textListeningPortLData.horizontalAlignment = 4;
        textListeningPortLData.grabExcessHorizontalSpace = true;
        this.textListeningPort.setLayoutData((Object)textListeningPortLData);
        this.textListeningPort.setEnabled(false);
        this.labelPassword = new Label((Composite)this.groupRemoteConnection, 0);
        this.labelPassword.setText(Messages.getString("PreferencesComposite.IncomingPassword") + ":");
        this.labelPassword.setEnabled(false);
        this.textPassword = new Text((Composite)this.groupRemoteConnection, 2048);
        GridData textPasswordLData = new GridData();
        this.textPassword.setEnabled(false);
        textPasswordLData.horizontalAlignment = 4;
        textPasswordLData.grabExcessHorizontalSpace = true;
        this.textPassword.setLayoutData((Object)textPasswordLData);
        this.updateComponent();
        content.layout();
    }

    public void updateComponent() {
        this.textPassword.setEchoChar('*');
        this.cbConfirmExit.setSelection(this.preferences.confirmExit());
        this.cbCloseMinimizesToSystemTray.setSelection(this.preferences.closeMinimizesToSystemTray());
        this.cbMinimizeMinimizesToSystemTray.setSelection(this.preferences.minimizeMinimizesToSystemTray());
        this.comboProfileList.setText(this.preferences.getProfileListStyle());
        this.comboLanguage.setText(PreferencesPage.getLanguageName(this.preferences.getLanguageCode()));
        this.cbListenForIncomming.setSelection(this.preferences.listeningForRemoteConnections());
        this.textListeningPort.setText(String.valueOf(this.preferences.getRemoteConnectionsPort()));
        this.textPassword.setText(this.preferences.getRemoteConnectionsPassword());
        this.cbAutostartScheduler.setSelection(this.preferences.getAutostartScheduler());
        this.updateRemoteConnectionGroup();
    }

    private void updateRemoteConnectionGroup() {
        if (this.cbListenForIncomming.getSelection()) {
            this.labelPort.setEnabled(true);
            this.textListeningPort.setEnabled(true);
            this.labelPassword.setEnabled(true);
            this.textPassword.setEnabled(true);
        } else {
            this.labelPort.setEnabled(false);
            this.textListeningPort.setEnabled(false);
            this.labelPassword.setEnabled(false);
            this.textPassword.setEnabled(false);
        }
    }

    @Override
    public boolean apply() {
        this.preferences.setConfirmExit(this.cbConfirmExit.getSelection());
        this.preferences.setCloseMinimizesToSystemTray(this.cbCloseMinimizesToSystemTray.getSelection());
        this.preferences.setMinimizeMinimizesToSystemTray(this.cbMinimizeMinimizesToSystemTray.getSelection());
        boolean profileListStyleChanged = !this.preferences.getProfileListStyle().equals(this.comboProfileList.getText());
        this.preferences.setProfileListStyle(this.comboProfileList.getText());
        this.preferences.setLanguageCode(PreferencesPage.getLanguageCode(this.comboLanguage.getText()));
        this.preferences.setAutostartScheduler(this.cbAutostartScheduler.getSelection());
        if (profileListStyleChanged) {
            GuiController.getInstance().getMainWindow().createProfileList();
        }
        boolean listenForIncoming = this.cbListenForIncomming.getSelection();
        this.preferences.setListeningForRemoteConnections(listenForIncoming);
        int port = -1;
        String password = null;
        if (listenForIncoming) {
            try {
                port = Integer.parseInt(this.textListeningPort.getText());
            }
            catch (NumberFormatException e) {
                ExceptionHandler.reportException(e);
            }
            this.preferences.setRemoteConnectionsPort(port);
            password = this.textPassword.getText();
            this.preferences.setRemoteConnectionsPassword(password);
            if (RemoteController.getInstance().isActive()) {
                int oldPort = RemoteController.getInstance().getPort();
                RemoteController.getInstance().setPassword(password);
                if (oldPort != port) {
                    MessageBox mb = new MessageBox(this.getShell(), 40);
                    mb.setText(Messages.getString("PreferencesComposite.Warning"));
                    mb.setMessage(Messages.getString("PreferencesComposite.RequiresRestart"));
                    mb.open();
                }
            } else if (port > 0) {
                try {
                    RemoteController.getInstance().startServer(port, password, GuiController.getInstance().getProfileManager(), GuiController.getInstance().getSynchronizer());
                }
                catch (RemoteException e) {
                    ExceptionHandler.reportException(e);
                    MessageBox mb = new MessageBox(this.getShell(), 33);
                    mb.setText(Messages.getString("PreferencesComposite.ConnectionError"));
                    mb.setMessage(Messages.getString("PreferencesComposite.UnableToStart") + ".\n(" + e.getMessage() + ")");
                    mb.open();
                }
            }
        } else {
            try {
                RemoteController.getInstance().stopServer();
            }
            catch (RemoteException e) {
                ExceptionHandler.reportException(e);
                MessageBox mb = new MessageBox(this.getShell(), 33);
                mb.setText(Messages.getString("PreferencesComposite.ConnectionError"));
                mb.setMessage(Messages.getString("PreferencesComposite.UnableToStop") + ".\n(" + e.getMessage() + ")");
                mb.open();
            }
        }
        this.preferences.save();
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

