/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.FileSystemException;
import net.sourceforge.fullsync.FileSystemManager;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.ProfileManager;
import net.sourceforge.fullsync.RuleSetDescriptor;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.impl.SimplyfiedRuleSetDescriptor;
import net.sourceforge.fullsync.rules.filefilter.FileFilter;
import net.sourceforge.fullsync.rules.filefilter.filefiltertree.FileFilterTree;
import net.sourceforge.fullsync.schedule.Schedule;
import net.sourceforge.fullsync.ui.ConnectionConfiguration;
import net.sourceforge.fullsync.ui.FileFilterPage;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ScheduleSelectionDialog;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProfileDetailsTabbedPage
extends WizardDialog
implements DisposeListener {
    private TabFolder tabs;
    private Text textProfileName;
    private Text textProfileDescription;
    private static final String EXPANDED_KEY = "Expanded";
    private static final String FILTER_KEY = "Filter";
    private ProfileManager profileManager;
    private Label labelFilesFilter;
    private Button buttonFileFilter;
    private Button buttonResetError;
    private Button buttonEnabled;
    private Button buttonScheduling;
    private Label labelTypeDescription;
    private Combo comboType;
    private ConnectionConfiguration dstConnectionConfiguration;
    private ConnectionConfiguration srcConnectionConfiguration;
    private Button buttonUseFileFilter;
    private Text textFilterDescription;
    private Button syncSubsButton;
    private TabItem tabSubDirs;
    private Button buttonSetFilter;
    private Button buttonRemoveFilter;
    private Tree directoryTree;
    private final Vector<TreeItem> treeItemsWithFilter = new Vector();
    private HashMap<String, FileFilter> itemsMap = new HashMap();
    private Site sourceSite;
    private final FileSystemManager fsm = new FileSystemManager();
    private Profile profile;
    private FileFilter filter;
    private Composite m_parent;
    private String lastSourceLoaded = null;

    public ProfileDetailsTabbedPage(Shell parent, ProfileManager profileManager, Profile profile) {
        super(parent);
        this.profileManager = profileManager;
        this.profile = profile;
    }

    @Override
    public String getTitle() {
        String title = Messages.getString("ProfileDetailsPage.Profile");
        if (this.profile != null) {
            title = title + " " + this.profile.getName();
        }
        return title;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ProfileDetailsPage.ProfileDetails");
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Image getIcon() {
        return GuiController.getInstance().getImage("Profile_Default.png");
    }

    @Override
    public Image getImage() {
        return GuiController.getInstance().getImage("Profile_Wizard.png");
    }

    @Override
    public void createContent(Composite content) {
        this.m_parent = content;
        content.addDisposeListener((DisposeListener)this);
        try {
            FileFilter fileFilter;
            this.tabs = new TabFolder(content, 0);
            GridData tabsData = new GridData(4, 4, true, true);
            this.tabs.setLayoutData((Object)tabsData);
            TabItem tabGeneral = new TabItem(this.tabs, 0);
            tabGeneral.setText("General");
            tabGeneral.setControl((Control)this.initGeneralTab((Composite)this.tabs));
            TabItem tabSource = new TabItem(this.tabs, 0);
            tabSource.setText(Messages.getString("ProfileDetails.Source.Label"));
            tabSource.setControl((Control)this.initSourceTab((Composite)this.tabs));
            TabItem tabDestination = new TabItem(this.tabs, 0);
            tabDestination.setText(Messages.getString("ProfileDetails.Destination.Label"));
            tabDestination.setControl((Control)this.initDestinationTab((Composite)this.tabs));
            TabItem tabFilters = new TabItem(this.tabs, 0);
            tabFilters.setText("Filters");
            tabFilters.setControl((Control)this.initFiltersTab((Composite)this.tabs));
            this.tabSubDirs = new TabItem(this.tabs, 0);
            this.tabSubDirs.setText("Subdirectories");
            this.tabSubDirs.setControl((Control)this.initSubDirsTab((Composite)this.tabs));
            this.tabs.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ProfileDetailsTabbedPage.this.treeTabsWidgetSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ProfileDetailsTabbedPage.this.treeTabsWidgetSelected(e);
                }
            });
            this.comboType.select(0);
            if (this.profile == null) {
                return;
            }
            this.textProfileName.setText(this.profile.getName());
            this.textProfileDescription.setText(this.profile.getDescription());
            this.srcConnectionConfiguration.setConnectionDescription(this.profile.getSource());
            if (null != this.profile.getSource()) {
                this.srcConnectionConfiguration.setBuffered("syncfiles".equals(this.profile.getSource().getParameter("bufferStrategy")));
            }
            this.dstConnectionConfiguration.setConnectionDescription(this.profile.getDestination());
            if (null != this.profile.getDestination()) {
                this.dstConnectionConfiguration.setBuffered("syncfiles".equals(this.profile.getDestination().getParameter("bufferStrategy")));
            }
            if (this.profile.getSynchronizationType() != null && this.profile.getSynchronizationType().length() > 0) {
                this.comboType.setText(this.profile.getSynchronizationType());
            }
            this.buttonScheduling.setData((Object)this.profile.getSchedule());
            this.buttonEnabled.setSelection(this.profile.isEnabled());
            RuleSetDescriptor ruleSetDescriptor = this.profile.getRuleSet();
            this.filter = null;
            SimplyfiedRuleSetDescriptor simpleDesc = (SimplyfiedRuleSetDescriptor)ruleSetDescriptor;
            this.syncSubsButton.setSelection(simpleDesc.isSyncSubDirs());
            this.filter = fileFilter = simpleDesc.getFileFilter();
            if (fileFilter != null) {
                this.textFilterDescription.setText(fileFilter.toString());
            } else {
                this.textFilterDescription.setText("");
            }
            boolean useFilter = simpleDesc.isUseFilter();
            this.buttonUseFileFilter.setSelection(useFilter);
            this.enableFilterControls(useFilter);
            FileFilterTree fileFilterTree = simpleDesc.getFileFilterTree();
            if (fileFilterTree != null) {
                this.itemsMap = fileFilterTree.getItemsMap();
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    private Composite initGeneralTab(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(c, 0);
        nameLabel.setText(Messages.getString("ProfileDetails.Name.Label") + ":");
        GridData textNameData = new GridData();
        textNameData.grabExcessHorizontalSpace = true;
        textNameData.horizontalAlignment = 4;
        this.textProfileName = new Text(c, 2048);
        this.textProfileName.setLayoutData((Object)textNameData);
        this.textProfileName.setToolTipText(Messages.getString("ProfileDetails.Name.ToolTip"));
        Label descriptionLabel = new Label(c, 0);
        descriptionLabel.setText(Messages.getString("ProfileDetails.Description.Label") + ":");
        GridData textDescriptionData = new GridData();
        textDescriptionData.horizontalAlignment = 4;
        this.textProfileDescription = new Text(c, 2048);
        this.textProfileDescription.setLayoutData((Object)textDescriptionData);
        Label typeLabel = new Label(c, 0);
        typeLabel.setText(Messages.getString("ProfileDetails.Type.Label"));
        this.comboType = new Combo(c, 12);
        GridData comboTypeData = new GridData(4);
        comboTypeData.horizontalAlignment = 4;
        this.comboType.setLayoutData((Object)comboTypeData);
        this.comboType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ProfileDetailsTabbedPage.this.srcConnectionConfiguration.setBuffered(false);
                ProfileDetailsTabbedPage.this.dstConnectionConfiguration.setBuffered(false);
                if (ProfileDetailsTabbedPage.this.comboType.getText().equals("Publish/Update")) {
                    ProfileDetailsTabbedPage.this.labelTypeDescription.setText(Messages.getString("ProfileDetails.ProfileDescription.Publish"));
                    ProfileDetailsTabbedPage.this.srcConnectionConfiguration.setBuffered(true);
                } else if (ProfileDetailsTabbedPage.this.comboType.getText().equals("Backup Copy")) {
                    ProfileDetailsTabbedPage.this.labelTypeDescription.setText(Messages.getString("ProfileDetails.ProfileDescription.BackupCopy"));
                } else if (ProfileDetailsTabbedPage.this.comboType.getText().equals("Exact Copy")) {
                    ProfileDetailsTabbedPage.this.labelTypeDescription.setText(Messages.getString("ProfileDetails.ProfileDescription.ExactCopy"));
                } else if (ProfileDetailsTabbedPage.this.comboType.getText().equals("Two Way Sync")) {
                    ProfileDetailsTabbedPage.this.labelTypeDescription.setText(Messages.getString("ProfileDetails.ProfileDescription.TwoWaySync"));
                }
            }
        });
        this.comboType.add("Publish/Update");
        this.comboType.add("Backup Copy");
        this.comboType.add("Exact Copy");
        this.comboType.add("Two Way Sync");
        new Label(c, 0);
        GridData labelTypeDescriptionData = new GridData();
        labelTypeDescriptionData.horizontalAlignment = 4;
        this.labelTypeDescription = new Label(c, 64);
        this.labelTypeDescription.setLayoutData((Object)labelTypeDescriptionData);
        this.labelTypeDescription.setText(Messages.getString("ProfileDetails.Description.Label"));
        Label labelAutomatedExecution = new Label(c, 0);
        labelAutomatedExecution.setText("Automated Execution");
        this.buttonEnabled = new Button(c, 131104);
        this.buttonEnabled.setText(Messages.getString("ProfileDetails.Enabled"));
        new Label(c, 0);
        this.buttonScheduling = new Button(c, 0x1000008);
        this.buttonScheduling.setText(Messages.getString("ProfileDetails.Edit_Scheduling"));
        this.buttonScheduling.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ScheduleSelectionDialog dialog = new ScheduleSelectionDialog(ProfileDetailsTabbedPage.this.m_parent.getShell(), 0);
                dialog.setSchedule((Schedule)ProfileDetailsTabbedPage.this.buttonScheduling.getData());
                dialog.open();
                ProfileDetailsTabbedPage.this.buttonScheduling.setData((Object)dialog.getSchedule());
            }
        });
        new Label(c, 0);
        this.buttonResetError = new Button(c, 131104);
        this.buttonResetError.setText(Messages.getString("ProfileDetails.Reset_ErrorFlag"));
        return c;
    }

    private Composite initSourceTab(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        GridData cData = new GridData();
        cData.grabExcessHorizontalSpace = true;
        cData.grabExcessVerticalSpace = false;
        cData.horizontalAlignment = 4;
        cData.verticalAlignment = 4;
        c.setLayoutData((Object)cData);
        ConnectionDescription src = null != this.profile ? this.profile.getSource() : null;
        this.srcConnectionConfiguration = new ConnectionConfiguration(c, src);
        this.srcConnectionConfiguration.setBufferedEnabled(false);
        return c;
    }

    private Composite initDestinationTab(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        GridData cData = new GridData();
        cData.grabExcessHorizontalSpace = true;
        cData.grabExcessVerticalSpace = false;
        cData.horizontalAlignment = 4;
        cData.verticalAlignment = 4;
        c.setLayoutData((Object)cData);
        ConnectionDescription dst = null != this.profile ? this.profile.getDestination() : null;
        this.dstConnectionConfiguration = new ConnectionConfiguration(c, dst);
        return c;
    }

    private Composite initFiltersTab(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.syncSubsButton = new Button(c, 16416);
        this.syncSubsButton.setText(Messages.getString("ProfileDetails.Sync_SubDirs"));
        this.syncSubsButton.setToolTipText(Messages.getString("ProfileDetails.Rucurre"));
        this.syncSubsButton.setSelection(true);
        GridData syncSubsButtonData = new GridData();
        syncSubsButtonData.horizontalSpan = 2;
        this.syncSubsButton.setLayoutData((Object)syncSubsButtonData);
        this.buttonUseFileFilter = new Button(c, 16416);
        GridData buttonUseFileFilterData = new GridData();
        buttonUseFileFilterData.horizontalSpan = 2;
        this.buttonUseFileFilter.setLayoutData((Object)buttonUseFileFilterData);
        this.buttonUseFileFilter.setText("Use file filter");
        this.buttonUseFileFilter.setSelection(false);
        this.buttonUseFileFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProfileDetailsTabbedPage.this.enableFilterControls(ProfileDetailsTabbedPage.this.buttonUseFileFilter.getSelection());
            }
        });
        this.labelFilesFilter = new Label(c, 0);
        this.labelFilesFilter.setText("Files Filter: ");
        this.buttonFileFilter = new Button(c, 0x1000008);
        this.buttonFileFilter.setText("Set Filter...");
        GridData buttonFileFilterData = new GridData();
        buttonFileFilterData.grabExcessHorizontalSpace = true;
        buttonFileFilterData.widthHint = 100;
        this.buttonFileFilter.setLayoutData((Object)buttonFileFilterData);
        this.buttonFileFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                try {
                    FileFilterPage dialog = new FileFilterPage(ProfileDetailsTabbedPage.this.m_parent.getShell(), ProfileDetailsTabbedPage.this.filter);
                    dialog.show();
                    FileFilter newfilter = dialog.getFileFilter();
                    if (newfilter != null) {
                        ProfileDetailsTabbedPage.this.filter = newfilter;
                        ProfileDetailsTabbedPage.this.textFilterDescription.setText(ProfileDetailsTabbedPage.this.filter.toString());
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.reportException(e);
                }
            }
        });
        this.textFilterDescription = new Text(c, 2624);
        GridData labelFilterDescriptionData = new GridData();
        labelFilterDescriptionData.horizontalSpan = 2;
        labelFilterDescriptionData.horizontalAlignment = 4;
        labelFilterDescriptionData.heightHint = 120;
        labelFilterDescriptionData.grabExcessHorizontalSpace = true;
        this.textFilterDescription.setLayoutData((Object)labelFilterDescriptionData);
        this.textFilterDescription.setText("");
        this.textFilterDescription.setEditable(false);
        this.enableFilterControls(false);
        return c;
    }

    private Composite initSubDirsTab(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.directoryTree = new Tree(c, 2052);
        GridData directoryTreeData = new GridData();
        directoryTreeData.grabExcessHorizontalSpace = true;
        directoryTreeData.grabExcessVerticalSpace = true;
        directoryTreeData.horizontalAlignment = 4;
        directoryTreeData.verticalAlignment = 4;
        this.directoryTree.setLayoutData((Object)directoryTreeData);
        this.directoryTree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent evt) {
                TreeItem[] childrens;
                TreeItem item = (TreeItem)evt.item;
                for (TreeItem children : childrens = item.getItems()) {
                    if (children.getData(ProfileDetailsTabbedPage.EXPANDED_KEY) != null) continue;
                    File file = (File)children.getData();
                    try {
                        ProfileDetailsTabbedPage.this.addChildren(file, children);
                    }
                    catch (IOException e) {
                        ExceptionHandler.reportException(e);
                    }
                    children.setData(ProfileDetailsTabbedPage.EXPANDED_KEY, new Object());
                }
            }
        });
        this.directoryTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProfileDetailsTabbedPage.this.buttonSetFilter.setEnabled(true);
                TreeItem item = (TreeItem)evt.item;
                FileFilter currentItemFilter = (FileFilter)item.getData(ProfileDetailsTabbedPage.FILTER_KEY);
                if (currentItemFilter != null) {
                    ProfileDetailsTabbedPage.this.buttonRemoveFilter.setEnabled(true);
                } else {
                    ProfileDetailsTabbedPage.this.buttonRemoveFilter.setEnabled(false);
                }
            }
        });
        Composite compositeButtons = new Composite(c, 0);
        GridLayout compositeButtonsLayout = new GridLayout();
        compositeButtonsLayout.makeColumnsEqualWidth = true;
        GridData compositeButtonsData = new GridData();
        compositeButtonsData.grabExcessVerticalSpace = true;
        compositeButtonsData.verticalAlignment = 4;
        compositeButtons.setLayoutData((Object)compositeButtonsData);
        compositeButtons.setLayout((Layout)compositeButtonsLayout);
        this.buttonSetFilter = new Button(compositeButtons, 0x1000008);
        GridData buttonSetFilterData = new GridData();
        buttonSetFilterData.widthHint = 100;
        this.buttonSetFilter.setLayoutData((Object)buttonSetFilterData);
        this.buttonSetFilter.setText("Set Filter...");
        this.buttonSetFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TreeItem[] selectedItems = ProfileDetailsTabbedPage.this.directoryTree.getSelection();
                if (selectedItems.length > 0) {
                    TreeItem selectedItem = selectedItems[0];
                    FileFilter currentItemFilter = (FileFilter)selectedItem.getData(ProfileDetailsTabbedPage.FILTER_KEY);
                    FileFilterPage dialog = new FileFilterPage(ProfileDetailsTabbedPage.this.m_parent.getShell(), currentItemFilter);
                    dialog.show();
                    FileFilter newfilter = dialog.getFileFilter();
                    if (newfilter != null) {
                        selectedItem.setData(ProfileDetailsTabbedPage.FILTER_KEY, (Object)newfilter);
                        ProfileDetailsTabbedPage.this.treeItemsWithFilter.add(selectedItem);
                        File file = (File)selectedItem.getData();
                        ProfileDetailsTabbedPage.this.itemsMap.put(file.getPath(), newfilter);
                        ProfileDetailsTabbedPage.this.markItem(selectedItem);
                        ProfileDetailsTabbedPage.this.buttonRemoveFilter.setEnabled(true);
                    }
                }
            }
        });
        this.buttonRemoveFilter = new Button(compositeButtons, 0x1000008);
        GridData buttonRemoveFilterData = new GridData();
        buttonRemoveFilterData.widthHint = 100;
        this.buttonRemoveFilter.setLayoutData((Object)buttonRemoveFilterData);
        this.buttonRemoveFilter.setText("Remove Filter");
        this.buttonRemoveFilter.setEnabled(false);
        this.buttonRemoveFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TreeItem[] selectedItems = ProfileDetailsTabbedPage.this.directoryTree.getSelection();
                if (selectedItems.length > 0) {
                    TreeItem selectedItem = selectedItems[0];
                    ProfileDetailsTabbedPage.this.treeItemsWithFilter.remove(selectedItem);
                    File file = (File)selectedItem.getData();
                    ProfileDetailsTabbedPage.this.itemsMap.remove(file.getPath());
                    ProfileDetailsTabbedPage.this.unmarkItem(selectedItem);
                }
            }
        });
        return c;
    }

    private void enableFilterControls(boolean enable) {
        this.labelFilesFilter.setEnabled(enable);
        this.buttonFileFilter.setEnabled(enable);
        this.textFilterDescription.setEnabled(enable);
    }

    private void drawDirectoryTree() {
        this.directoryTree.setRedraw(false);
        this.directoryTree.removeAll();
        try {
            for (File file : this.getOrderedChildren(this.sourceSite.getRoot())) {
                if (!file.isDirectory()) continue;
                TreeItem item = new TreeItem(this.directoryTree, 0);
                item.setText(file.getName());
                item.setImage(GuiController.getInstance().getImage("Node_Directory.png"));
                item.setData((Object)file);
                if (this.itemsMap.containsKey(file.getPath())) {
                    this.markItem(item);
                    this.treeItemsWithFilter.add(item);
                    item.setData(FILTER_KEY, (Object)this.itemsMap.get(file.getPath()));
                }
                this.addChildren(file, item);
                item.setData(EXPANDED_KEY, new Object());
            }
        }
        catch (IOException e) {
            ExceptionHandler.reportException(e);
        }
        this.directoryTree.setRedraw(true);
    }

    private void addChildren(File rootFile, TreeItem item) throws IOException {
        for (File file : this.getOrderedChildren(rootFile)) {
            if (!file.isDirectory()) continue;
            TreeItem childrenItem = new TreeItem(item, 0);
            childrenItem.setText(file.getName());
            childrenItem.setImage(GuiController.getInstance().getImage("Node_Directory.png"));
            childrenItem.setData((Object)file);
            if (!this.itemsMap.containsKey(file.getPath())) continue;
            this.markItem(childrenItem);
            this.treeItemsWithFilter.add(childrenItem);
            childrenItem.setData(FILTER_KEY, (Object)this.itemsMap.get(file.getPath()));
        }
    }

    private List<File> getOrderedChildren(File rootFile) throws IOException {
        ArrayList<File> children = new ArrayList<File>(rootFile.getChildren());
        Collections.sort(children, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return children;
    }

    private void markItem(TreeItem item) {
        String text = item.getText();
        if (text.charAt(0) != '*') {
            item.setText('*' + text);
        }
    }

    private void unmarkItem(TreeItem item) {
        String text = item.getText();
        if (text.charAt(0) == '*') {
            item.setText(text.substring(1));
        }
    }

    @Override
    public boolean apply() {
        Profile pr;
        ConnectionDescription dst;
        ConnectionDescription src;
        this.closeSourceSite();
        try {
            src = this.getConnectionDescription(this.srcConnectionConfiguration);
            dst = this.getConnectionDescription(this.dstConnectionConfiguration);
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
            return false;
        }
        if (!(this.profile != null && this.textProfileName.getText().equals(this.profile.getName()) || (pr = this.profileManager.getProfile(this.textProfileName.getText())) == null)) {
            MessageBox mb = new MessageBox(this.m_parent.getShell(), 1);
            mb.setText(Messages.getString("ProfileDetails.Duplicate_Entry"));
            mb.setMessage(Messages.getString("ProfileDetails.Profile_already_exists"));
            mb.open();
            return false;
        }
        SimplyfiedRuleSetDescriptor ruleSetDescriptor = null;
        ruleSetDescriptor = new SimplyfiedRuleSetDescriptor(this.syncSubsButton.getSelection(), this.filter, this.buttonUseFileFilter.getSelection(), this.getFileFilterTree());
        if (this.profile == null) {
            this.profile = new Profile(this.textProfileName.getText(), src, dst, ruleSetDescriptor);
            this.profile.setSynchronizationType(this.comboType.getText());
            this.profile.setDescription(this.textProfileDescription.getText());
            this.profile.setSchedule((Schedule)this.buttonScheduling.getData());
            this.profile.setEnabled(this.buttonEnabled.getSelection());
            if (this.buttonResetError.getSelection()) {
                this.profile.setLastError(0, null);
            }
            this.profileManager.addProfile(this.profile);
        } else {
            this.profile.beginUpdate();
            this.profile.setName(this.textProfileName.getText());
            this.profile.setDescription(this.textProfileDescription.getText());
            this.profile.setSynchronizationType(this.comboType.getText());
            this.profile.setSource(src);
            this.profile.setDestination(dst);
            this.profile.setSchedule((Schedule)this.buttonScheduling.getData());
            this.profile.setEnabled(this.buttonEnabled.getSelection());
            this.profile.setRuleSet(ruleSetDescriptor);
            if (this.buttonResetError.getSelection()) {
                this.profile.setLastError(0, null);
            }
            this.profile.endUpdate();
        }
        this.profileManager.save();
        return true;
    }

    private ConnectionDescription getConnectionDescription(ConnectionConfiguration cfg) {
        ConnectionDescription dst = null;
        try {
            dst = cfg.getConnectionDescription();
            if (cfg.getBuffered()) {
                dst.setParameter("bufferStrategy", "syncfiles");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return dst;
    }

    private void treeTabsWidgetSelected(SelectionEvent evt) {
        if (evt.item == this.tabSubDirs) {
            final ConnectionDescription src = this.getConnectionDescription(this.srcConnectionConfiguration);
            if (this.sourceSite == null || src == null || !src.getUri().toString().equals(this.lastSourceLoaded)) {
                this.directoryTree.removeAll();
                TreeItem loadingIem = new TreeItem(this.directoryTree, 0);
                loadingIem.setText("Loading source dir...");
                loadingIem.setImage(GuiController.getInstance().getImage("Node_Directory.png"));
                Display display = Display.getCurrent();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (null != src) {
                                ProfileDetailsTabbedPage.this.closeSourceSite();
                                src.setParameter("bufferStrategy", "");
                                src.setParameter("interactive", "true");
                                ProfileDetailsTabbedPage.this.sourceSite = ProfileDetailsTabbedPage.this.fsm.createConnection(src);
                                ProfileDetailsTabbedPage.this.drawDirectoryTree();
                                ProfileDetailsTabbedPage.this.lastSourceLoaded = src.getUri().toString();
                            } else {
                                TreeItem loadingIem = new TreeItem(ProfileDetailsTabbedPage.this.directoryTree, 0);
                                loadingIem.setText("Unable to load source dir");
                                loadingIem.setImage(GuiController.getInstance().getImage("Error.png"));
                            }
                        }
                        catch (org.apache.commons.vfs2.FileSystemException e) {
                            ExceptionHandler.reportException(e);
                            ProfileDetailsTabbedPage.this.directoryTree.removeAll();
                            TreeItem loadingIem = new TreeItem(ProfileDetailsTabbedPage.this.directoryTree, 0);
                            loadingIem.setText("Unable to load source dir");
                            loadingIem.setImage(GuiController.getInstance().getImage("Error.png"));
                        }
                        catch (IOException e) {
                            ExceptionHandler.reportException(e);
                            ProfileDetailsTabbedPage.this.directoryTree.removeAll();
                            TreeItem loadingIem = new TreeItem(ProfileDetailsTabbedPage.this.directoryTree, 0);
                            loadingIem.setText("Unable to load source dir");
                            loadingIem.setImage(GuiController.getInstance().getImage("Error.png"));
                        }
                        catch (URISyntaxException e) {
                            ExceptionHandler.reportException(e);
                            ProfileDetailsTabbedPage.this.directoryTree.removeAll();
                            TreeItem loadingIem = new TreeItem(ProfileDetailsTabbedPage.this.directoryTree, 0);
                            loadingIem.setText("Unable to load source dir");
                            loadingIem.setImage(GuiController.getInstance().getImage("Error.png"));
                        }
                        catch (FileSystemException e) {
                            ExceptionHandler.reportException(e);
                            ProfileDetailsTabbedPage.this.directoryTree.removeAll();
                            TreeItem loadingIem = new TreeItem(ProfileDetailsTabbedPage.this.directoryTree, 0);
                            loadingIem.setText("Unable to load source dir");
                            loadingIem.setImage(GuiController.getInstance().getImage("Error.png"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    private FileFilterTree getFileFilterTree() {
        FileFilterTree fileFilterTree = new FileFilterTree();
        for (TreeItem item : this.treeItemsWithFilter) {
            FileFilter itemFilter = (FileFilter)item.getData(FILTER_KEY);
            File itemFile = (File)item.getData();
            fileFilterTree.addFileFilter(itemFile.getPath(), itemFilter);
        }
        return fileFilterTree;
    }

    private void closeSourceSite() {
        if (this.sourceSite != null) {
            try {
                this.sourceSite.close();
                this.sourceSite = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final void widgetDisposed(DisposeEvent e) {
        this.closeSourceSite();
    }

    @Override
    public boolean cancel() {
        return true;
    }
}

