/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.FileSystemManager;
import net.sourceforge.fullsync.fs.Site;
import net.sourceforge.fullsync.ui.FileObjectChooser;
import net.sourceforge.fullsync.ui.Messages;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class ProtocolSpecificComposite {
    private Label labelPath = null;
    protected Text textPath = null;
    private Button buttonBrowse = null;
    private Button buttonBuffered = null;
    protected String m_scheme = null;
    protected Composite m_parent = null;

    ProtocolSpecificComposite() {
    }

    public void createGUI(Composite parent) {
        this.m_parent = parent;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0x1000000;
        this.labelPath = new Label(parent, 0);
        this.labelPath.setText("Path:");
        this.textPath = new Text(parent, 2048);
        this.textPath.setLayoutData((Object)gridData);
        this.buttonBrowse = new Button(parent, 0);
        this.buttonBrowse.setText("...");
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProtocolSpecificComposite.this.onBrowse();
            }
        });
        this.buttonBuffered = new Button(parent, 16416);
        GridData buttonDestinationBufferedData = new GridData();
        buttonDestinationBufferedData.horizontalSpan = 3;
        this.buttonBuffered.setLayoutData((Object)buttonDestinationBufferedData);
        this.buttonBuffered.setText(Messages.getString("ProfileDetails.Buffered.Label"));
        this.buttonBuffered.setVisible(false);
    }

    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        String path = this.textPath.getText();
        if (null == path || 0 == path.length()) {
            path = "/";
        }
        return new ConnectionDescription(new URI(this.m_scheme, null, path, null));
    }

    public void setConnectionDescription(ConnectionDescription connection) {
        if (null != connection && null != connection.getUri()) {
            this.textPath.setText(connection.getUri().getPath());
        } else {
            this.textPath.setText("");
        }
    }

    public void reset(String scheme) {
        this.m_scheme = scheme;
        this.textPath.setText("");
    }

    protected void setPath(String path) {
        this.textPath.setText(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBrowse() {
        Site conn = null;
        try {
            ConnectionDescription desc = this.getConnectionDescription();
            FileSystemManager fsm = new FileSystemManager();
            desc.setParameter("interactive", "true");
            conn = fsm.createConnection(desc);
            FileObject base = conn.getBase();
            FileObjectChooser foc = new FileObjectChooser(this.m_parent.getShell(), 0);
            foc.setBaseFileObject(base);
            foc.setSelectedFileObject(base);
            if (foc.open()) {
                URI uri = new URI(foc.getActiveFileObject().getName().getURI());
                this.setPath(uri.getPath());
            }
        }
        catch (Exception e1) {
            ExceptionHandler.reportException(e1);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public boolean getBuffered() {
        return this.buttonBuffered.getEnabled() && this.buttonBuffered.getSelection();
    }

    public void setBuffered(boolean buffered) {
        this.buttonBuffered.setSelection(buffered);
    }

    public void setBufferedEnabled(boolean enabled) {
        this.buttonBuffered.setEnabled(enabled);
    }
}

