/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.net.URI;
import java.net.URISyntaxException;
import net.sourceforge.fullsync.ConnectionDescription;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ProtocolSpecificComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

class SFTPSpecificComposite
extends ProtocolSpecificComposite {
    private static final int DEFAULT_SFTP_PORT = 22;
    private Label labelHost = null;
    private Text textHost = null;
    private Label labelPort = null;
    private Spinner spinnerPort = null;
    private Label labelUsername = null;
    private Text textUsername = null;
    private Label labelPassword = null;
    private Text textPassword = null;
    private Button buttonKeybased = null;
    private Label labelKeyPassphrase = null;
    private Text textKeyPassphrase = null;

    SFTPSpecificComposite() {
    }

    @Override
    public void createGUI(Composite parent) {
        this.m_parent = parent;
        GridData gridData1 = new GridData(4, 0x1000000, true, false);
        gridData1.horizontalSpan = 2;
        this.labelHost = new Label(this.m_parent, 0);
        this.labelHost.setText(Messages.getString("ProtocolSpecificComposite.Host"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0x1000000;
        this.textHost = new Text(this.m_parent, 2048);
        GridData gridData3 = new GridData(4, 0x1000000, true, false);
        gridData3.horizontalSpan = 2;
        this.textHost.setLayoutData((Object)gridData3);
        this.labelPort = new Label(parent, 0);
        this.labelPort.setText("Port:");
        this.spinnerPort = new Spinner(parent, 2048);
        this.spinnerPort.setMinimum(1);
        this.spinnerPort.setMaximum(65535);
        this.spinnerPort.setSelection(22);
        GridData gridData4 = new GridData(4, 0x1000000, true, false);
        gridData4.horizontalSpan = 2;
        this.spinnerPort.setLayoutData((Object)gridData4);
        this.labelUsername = new Label(this.m_parent, 0);
        this.labelUsername.setText(Messages.getString("ProtocolSpecificComposite.Username"));
        this.textUsername = new Text(this.m_parent, 2048);
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.horizontalSpan = 2;
        this.textUsername.setLayoutData((Object)gridData2);
        this.labelPassword = new Label(this.m_parent, 0);
        this.labelPassword.setText(Messages.getString("ProtocolSpecificComposite.Password"));
        this.textPassword = new Text(this.m_parent, 2048);
        this.textPassword.setLayoutData((Object)gridData1);
        this.textPassword.setEchoChar('*');
        this.buttonKeybased = new Button(this.m_parent, 32);
        this.buttonKeybased.setText(Messages.getString("ProtocolSpecificComposite.Keybased"));
        GridData radioKeybasedData = new GridData();
        radioKeybasedData.horizontalSpan = 3;
        this.buttonKeybased.setLayoutData((Object)radioKeybasedData);
        this.buttonKeybased.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = SFTPSpecificComposite.this.buttonKeybased.getSelection();
                SFTPSpecificComposite.this.labelKeyPassphrase.setEnabled(enabled);
                SFTPSpecificComposite.this.textKeyPassphrase.setEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                boolean enabled = SFTPSpecificComposite.this.buttonKeybased.getSelection();
                SFTPSpecificComposite.this.labelKeyPassphrase.setEnabled(enabled);
                SFTPSpecificComposite.this.textKeyPassphrase.setEnabled(enabled);
            }
        });
        this.labelKeyPassphrase = new Label(this.m_parent, 0);
        this.labelKeyPassphrase.setText(Messages.getString("ProtocolSpecificComposite.KeyPassphrase"));
        this.textKeyPassphrase = new Text(this.m_parent, 2048);
        this.textKeyPassphrase.setEchoChar('*');
        GridData textKeyPassphraseData = new GridData(4, 0x1000000, true, false);
        textKeyPassphraseData.horizontalSpan = 2;
        this.textKeyPassphrase.setLayoutData((Object)textKeyPassphraseData);
        super.createGUI(parent);
    }

    @Override
    public ConnectionDescription getConnectionDescription() throws URISyntaxException {
        ConnectionDescription loc = super.getConnectionDescription();
        loc.setUri(new URI(this.m_scheme, null, this.textHost.getText(), this.spinnerPort.getSelection(), loc.getUri().getPath(), null, null));
        loc.setParameter("username", this.textUsername.getText());
        loc.setSecretParameter("password", this.textPassword.getText());
        loc.setParameter("publicKeyAuth", this.buttonKeybased.getSelection() ? "enabled" : "disabled");
        loc.setSecretParameter("keyPassphrase", this.textKeyPassphrase.getText());
        return loc;
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connection) {
        super.setConnectionDescription(connection);
        URI uri = connection.getUri();
        this.textHost.setText(uri.getHost());
        int port = uri.getPort();
        if (-1 == port) {
            port = 22;
        }
        this.spinnerPort.setSelection(port);
        this.textUsername.setText(connection.getParameter("username"));
        this.textPassword.setText(connection.getSecretParameter("password"));
        this.buttonKeybased.setSelection("enabled".equals(connection.getParameter("publicKeyAuth")));
        this.labelKeyPassphrase.setEnabled(this.buttonKeybased.getSelection());
        this.textKeyPassphrase.setEnabled(this.buttonKeybased.getSelection());
        String keyPassphrase = connection.getSecretParameter("keyPassphrase");
        if (null != keyPassphrase) {
            this.textKeyPassphrase.setText(keyPassphrase);
        }
    }

    @Override
    public void reset(String scheme) {
        super.reset(scheme);
        this.textHost.setText("");
        this.spinnerPort.setSelection(22);
        this.textUsername.setText("");
        this.textPassword.setText("");
        this.buttonKeybased.setSelection(false);
        this.textKeyPassphrase.setText("");
        this.textKeyPassphrase.setEnabled(false);
        this.labelKeyPassphrase.setEnabled(false);
    }
}

