/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.schedule.Schedule;
import net.sourceforge.fullsync.ui.CrontabScheduleOptions;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.IntervalScheduleOptions;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.ScheduleOptions;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ScheduleSelectionDialog
extends Dialog {
    private Group groupOptions;
    private Combo cbType;
    private Shell dialogShell;
    private Schedule schedule;

    public ScheduleSelectionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open() {
        try {
            this.dialogShell = new Shell(this.getParent(), 67696);
            this.dialogShell.setText(Messages.getString("ScheduleSelectionDialog.EditScheduling"));
            this.dialogShell.setImage(GuiController.getInstance().getImage("Scheduler_Icon.png"));
            GridLayout thisLayout = new GridLayout();
            thisLayout.numColumns = 2;
            this.dialogShell.setLayout((Layout)thisLayout);
            Composite compositeTop = new Composite((Composite)this.dialogShell, 0);
            GridLayout compositeTopLayout = new GridLayout();
            GridData compositeTopLData = new GridData();
            compositeTopLData.horizontalSpan = 2;
            compositeTopLData.horizontalAlignment = 4;
            compositeTop.setLayoutData((Object)compositeTopLData);
            compositeTopLayout.numColumns = 2;
            compositeTop.setLayout((Layout)compositeTopLayout);
            Label labelScheduleType = new Label(compositeTop, 0);
            labelScheduleType.setText(Messages.getString("ScheduleSelectionDialog.SchedulingType") + ":");
            GridData labelScheduleTypeLData = new GridData();
            labelScheduleType.setLayoutData((Object)labelScheduleTypeLData);
            this.cbType = new Combo(compositeTop, 12);
            GridData cbTypeLData = new GridData();
            cbTypeLData.horizontalAlignment = 4;
            cbTypeLData.grabExcessHorizontalSpace = true;
            this.cbType.setLayoutData((Object)cbTypeLData);
            this.cbType.addListener(24, new Listener(){

                public void handleEvent(Event arg0) {
                    Control[] children = ScheduleSelectionDialog.this.groupOptions.getChildren();
                    if (ScheduleSelectionDialog.this.cbType.getSelectionIndex() > -1 && ScheduleSelectionDialog.this.cbType.getSelectionIndex() < children.length) {
                        Control c;
                        ((StackLayout)((ScheduleSelectionDialog)ScheduleSelectionDialog.this).groupOptions.getLayout()).topControl = c = children[ScheduleSelectionDialog.this.cbType.getSelectionIndex()];
                        ScheduleSelectionDialog.this.groupOptions.layout();
                    }
                }
            });
            this.groupOptions = new Group((Composite)this.dialogShell, 4);
            StackLayout groupOptionsLayout = new StackLayout();
            GridData groupOptionsLData = new GridData();
            groupOptionsLData.grabExcessVerticalSpace = true;
            groupOptionsLData.grabExcessHorizontalSpace = true;
            groupOptionsLData.horizontalAlignment = 4;
            groupOptionsLData.verticalAlignment = 4;
            groupOptionsLData.horizontalSpan = 2;
            this.groupOptions.setLayoutData((Object)groupOptionsLData);
            this.groupOptions.setLayout((Layout)groupOptionsLayout);
            this.groupOptions.setText(Messages.getString("ScheduleSelectionDialog.Options"));
            Button buttonOk = new Button((Composite)this.dialogShell, 0x1000008);
            buttonOk.setText(Messages.getString("ScheduleSelectionDialog.Ok"));
            GridData buttonOkLData = new GridData();
            buttonOkLData.horizontalAlignment = 0x1000008;
            buttonOkLData.grabExcessHorizontalSpace = true;
            buttonOkLData.heightHint = 25;
            buttonOkLData.widthHint = 100;
            buttonOk.setLayoutData((Object)buttonOkLData);
            buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    try {
                        ScheduleSelectionDialog.this.schedule = ((ScheduleOptions)((StackLayout)((ScheduleSelectionDialog)ScheduleSelectionDialog.this).groupOptions.getLayout()).topControl).getSchedule();
                        ScheduleSelectionDialog.this.dialogShell.dispose();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.reportException(ex);
                    }
                }
            });
            Button buttonCancel = new Button((Composite)this.dialogShell, 0x1000008);
            buttonCancel.setText(Messages.getString("ScheduleSelectionDialog.Cancel"));
            GridData buttonCancelLData = new GridData();
            buttonCancelLData.heightHint = 25;
            buttonCancelLData.widthHint = 100;
            buttonCancel.setLayoutData((Object)buttonCancelLData);
            buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ScheduleSelectionDialog.this.dialogShell.dispose();
                }
            });
            this.addScheduleOptions(new NullScheduleOptions((Composite)this.groupOptions, 0));
            this.cbType.select(0);
            this.addScheduleOptions(new IntervalScheduleOptions((Composite)this.groupOptions, 0));
            this.addScheduleOptions(new CrontabScheduleOptions((Composite)this.groupOptions, 0));
            Display display = this.dialogShell.getDisplay();
            this.dialogShell.setSize(350, 350);
            Rectangle rect = this.getParent().getBounds();
            this.dialogShell.setLocation(rect.x + rect.width / 2 - this.dialogShell.getSize().x / 2, rect.y + rect.height / 2 - this.dialogShell.getSize().y / 2);
            this.dialogShell.layout();
            this.dialogShell.open();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
    }

    public void addScheduleOptions(ScheduleOptions options) {
        this.cbType.add(options.getSchedulingName());
        if (options.canHandleSchedule(this.schedule)) {
            this.cbType.setText(options.getSchedulingName());
            options.setSchedule(this.schedule);
        }
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    class NullScheduleOptions
    extends ScheduleOptions {
        public NullScheduleOptions(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        public String getSchedulingName() {
            return Messages.getString("ScheduleSelectionDialog.none");
        }

        @Override
        public boolean canHandleSchedule(Schedule sched) {
            return false;
        }

        @Override
        public Schedule getSchedule() {
            return null;
        }

        @Override
        public void setSchedule(Schedule sched) {
        }
    }
}

