/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.fullsync.ui.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SystemStatusPage
extends WizardDialog {
    private Label totalMemory;
    private Label maxMemory;
    private Label freeMemory;
    private ProgressBar progressBarMemory;
    private Timer timer;
    private Composite content;

    public SystemStatusPage(Shell parent) {
        super(parent);
    }

    @Override
    public String getTitle() {
        return "System Status";
    }

    @Override
    public String getCaption() {
        return "System Status";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public void createContent(Composite content) {
        this.content = content;
        try {
            content.setLayout((Layout)new GridLayout());
            Group groupMemory = new Group(content, 0);
            groupMemory.setLayout((Layout)new GridLayout(2, false));
            groupMemory.setText("VM Memory");
            this.progressBarMemory = new ProgressBar((Composite)groupMemory, 0);
            GridData progressBarMemoryLData = new GridData();
            progressBarMemoryLData.horizontalAlignment = 4;
            progressBarMemoryLData.horizontalSpan = 2;
            this.progressBarMemory.setLayoutData((Object)progressBarMemoryLData);
            Label labelTotalMemory = new Label((Composite)groupMemory, 0);
            labelTotalMemory.setText("Total Memory:");
            this.totalMemory = new Label((Composite)groupMemory, 131072);
            GridData totalMemoryLData = new GridData();
            totalMemoryLData.horizontalAlignment = 4;
            this.totalMemory.setLayoutData((Object)totalMemoryLData);
            Label labelMaxMemory = new Label((Composite)groupMemory, 0);
            labelMaxMemory.setText("Max Memory:");
            this.maxMemory = new Label((Composite)groupMemory, 131072);
            GridData maxMemoryLData = new GridData();
            maxMemoryLData.horizontalAlignment = 4;
            this.maxMemory.setLayoutData((Object)maxMemoryLData);
            Label labelFreeMemory = new Label((Composite)groupMemory, 0);
            labelFreeMemory.setText("Free Memory:");
            this.freeMemory = new Label((Composite)groupMemory, 131072);
            this.freeMemory.setText("<free memory>");
            GridData freeMemoryLData = new GridData();
            freeMemoryLData.horizontalAlignment = 4;
            this.freeMemory.setLayoutData((Object)freeMemoryLData);
            Button buttonMemoryGc = new Button((Composite)groupMemory, 0x1000008);
            buttonMemoryGc.setText("Clean up");
            GridData buttonMemoryGcLData = new GridData();
            buttonMemoryGc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    System.gc();
                }
            });
            buttonMemoryGcLData.horizontalAlignment = 0x1000008;
            buttonMemoryGcLData.horizontalSpan = 2;
            buttonMemoryGc.setLayoutData((Object)buttonMemoryGcLData);
            this.updateView();
            this.timer = new Timer(true);
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SystemStatusPage.this.updateView();
                }
            }, 1000L, 1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean apply() {
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    public void updateView() {
        if (!this.content.isDisposed()) {
            Display display = this.getDisplay();
            if (display == null || display.isDisposed()) {
                this.timer.cancel();
                return;
            }
            final Composite comp = this.content;
            display.syncExec(new Runnable(){
                private final String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
                private final long kilo = 1024L;

                private void setFormattedText(Label l, long origValue) {
                    long unit = 0L;
                    long value = origValue;
                    while (value > 1024L) {
                        value /= 1024L;
                        ++unit;
                    }
                    l.setText(String.valueOf(value) + " " + this.units[(int)unit]);
                }

                @Override
                public void run() {
                    Runtime rt = Runtime.getRuntime();
                    long ltotalMemory = rt.totalMemory();
                    long lmaxMemory = rt.maxMemory();
                    long lfreeMemory = rt.freeMemory();
                    this.setFormattedText(SystemStatusPage.this.totalMemory, ltotalMemory);
                    this.setFormattedText(SystemStatusPage.this.maxMemory, lmaxMemory);
                    this.setFormattedText(SystemStatusPage.this.freeMemory, lfreeMemory);
                    SystemStatusPage.this.progressBarMemory.setMaximum((int)(ltotalMemory / 1024L));
                    SystemStatusPage.this.progressBarMemory.setSelection((int)((ltotalMemory - lfreeMemory) / 1024L));
                    comp.layout();
                }
            });
        }
    }

    @Override
    public void dispose() {
        this.timer.cancel();
        super.dispose();
    }
}

