/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.Timer;
import java.util.TimerTask;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskGenerationListener;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SystemTrayItem
implements TaskGenerationListener {
    private TrayItem trayItem;
    private Menu menu;
    private Image[] imageList;
    private int imageActive;
    private Timer timer;
    private boolean isBusy;

    public SystemTrayItem(final GuiController guiController) {
        Tray tray = guiController.getDisplay().getSystemTray();
        this.trayItem = new TrayItem(tray, 0);
        this.imageList = new Image[2];
        this.imageList[0] = guiController.getImage("fullsync48.png");
        this.imageList[1] = guiController.getImage("fullsync48_r.png");
        this.imageActive = 0;
        this.trayItem.setImage(this.imageList[0]);
        this.trayItem.setToolTipText("FullSync");
        this.trayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                guiController.setMainShellVisible(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                guiController.setMainShellVisible(true);
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event evt) {
                SystemTrayItem.this.menu.setVisible(true);
            }
        });
        this.menu = new Menu((Decorations)guiController.getMainShell(), 8);
        MenuItem item = new MenuItem(this.menu, 0);
        item.setImage(guiController.getImage("fullsync16.png"));
        item.setText(Messages.getString("SystemTrayItem.OpenFullSync"));
        item.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                guiController.setMainShellVisible(true);
            }
        });
        item = new MenuItem(this.menu, 0);
        item.setText(Messages.getString("SystemTrayItem.Exit"));
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                guiController.closeGui();
            }
        });
        guiController.getSynchronizer().getTaskGenerator().addTaskGenerationListener(this);
    }

    public void setVisible(boolean visible) {
        this.trayItem.setVisible(visible);
    }

    public boolean isDisposed() {
        return this.trayItem.isDisposed();
    }

    public void dispose() {
        this.trayItem.dispose();
        this.menu.dispose();
    }

    @Override
    public void taskGenerationStarted(File source, File destination) {
    }

    @Override
    public void taskGenerationFinished(Task task) {
    }

    @Override
    public synchronized void taskTreeStarted(TaskTree tree) {
        if (!this.isBusy) {
            this.timer = new Timer();
            this.isBusy = true;
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SystemTrayItem.this.imageActive++;
                    if (SystemTrayItem.this.imageActive >= SystemTrayItem.this.imageList.length) {
                        SystemTrayItem.this.imageActive = 0;
                    }
                    SystemTrayItem.this.trayItem.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SystemTrayItem.this.trayItem.setImage(SystemTrayItem.this.imageList[SystemTrayItem.this.imageActive]);
                        }
                    });
                }
            }, 0L, 500L);
        }
    }

    @Override
    public synchronized void taskTreeFinished(TaskTree tree) {
        if (this.isBusy) {
            this.isBusy = false;
            this.timer.cancel();
            this.timer = null;
            this.imageActive = 0;
            this.trayItem.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SystemTrayItem.this.trayItem.setImage(SystemTrayItem.this.imageList[SystemTrayItem.this.imageActive]);
                }
            });
        }
    }
}

