/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fullsync.ui;

import java.util.HashMap;
import java.util.Hashtable;
import net.sourceforge.fullsync.Action;
import net.sourceforge.fullsync.ExceptionHandler;
import net.sourceforge.fullsync.Profile;
import net.sourceforge.fullsync.Task;
import net.sourceforge.fullsync.TaskTree;
import net.sourceforge.fullsync.fs.File;
import net.sourceforge.fullsync.ui.GuiController;
import net.sourceforge.fullsync.ui.Messages;
import net.sourceforge.fullsync.ui.TaskDecisionPage;
import net.sourceforge.fullsync.ui.UISettings;
import net.sourceforge.fullsync.ui.WizardDialogListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TaskDecisionList
extends Composite {
    private TableColumn tableColumnExplanation;
    private TableColumn tableColumnFilename;
    private TableColumn tableColumnAction;
    private TableColumn tableColumnSourceSize;
    private Table tableLogLines;
    private int tableLogLinesFillIndex;
    private int tableLogLinesFillCount;
    private Hashtable<Integer, Image> actionImages;
    private Hashtable<Integer, Image> taskImages;
    private Image locationSource;
    private Image locationDestination;
    private Image locationBoth;
    private Image nodeFile;
    private Image nodeDirectory;
    private Image nodeUndefined;
    private TaskTree taskTree;
    private final HashMap<Task, TableItem> taskItemMap = new HashMap();
    private boolean onlyChanges;
    private boolean changeAllowed;

    public TaskDecisionList(Composite parent, int style) {
        super(parent, style);
        try {
            this.setSize(550, 500);
            this.tableLogLines = new Table((Composite)this, 67586);
            GridData tableLogLinesLData = new GridData();
            tableLogLinesLData.verticalAlignment = 4;
            tableLogLinesLData.horizontalAlignment = 4;
            tableLogLinesLData.horizontalIndent = 0;
            tableLogLinesLData.horizontalSpan = 3;
            tableLogLinesLData.grabExcessHorizontalSpace = true;
            tableLogLinesLData.grabExcessVerticalSpace = true;
            this.tableLogLines.setLayoutData((Object)tableLogLinesLData);
            this.tableLogLines.setHeaderVisible(true);
            this.tableLogLines.setLinesVisible(true);
            this.tableColumnFilename = new TableColumn(this.tableLogLines, 0);
            this.tableColumnFilename.setText(Messages.getString("TaskDecisionList.Filename"));
            this.tableColumnFilename.setWidth(240);
            this.tableColumnSourceSize = new TableColumn(this.tableLogLines, 0);
            this.tableColumnSourceSize.setText(Messages.getString("TaskDecisionList.Size"));
            this.tableColumnSourceSize.setAlignment(131072);
            this.tableColumnSourceSize.setWidth(90);
            this.tableColumnAction = new TableColumn(this.tableLogLines, 0);
            this.tableColumnAction.setResizable(false);
            this.tableColumnAction.setText(Messages.getString("TaskDecisionList.Action"));
            this.tableColumnAction.setWidth(70);
            this.tableColumnExplanation = new TableColumn(this.tableLogLines, 0);
            this.tableColumnExplanation.setText(Messages.getString("TaskDecisionList.Explanation"));
            this.tableColumnExplanation.setWidth(170);
            this.tableLogLines.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent evt) {
                    TaskDecisionList.this.tableLogLinesMouseUp(evt);
                }
            });
            GridLayout thisLayout = new GridLayout();
            this.setLayout((Layout)thisLayout);
            this.layout();
        }
        catch (Exception e) {
            ExceptionHandler.reportException(e);
        }
        this.initializeImages();
        this.onlyChanges = true;
        this.changeAllowed = true;
    }

    public static void show(final GuiController guiController, Profile profile, final TaskTree task, final boolean interactive) {
        Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    final TaskDecisionPage dialog = new TaskDecisionPage(guiController.getMainShell(), guiController, task);
                    if (!interactive) {
                        dialog.addWizardDialogListener(new WizardDialogListener(){

                            @Override
                            public void dialogOpened() {
                                dialog.performActions();
                            }
                        });
                    }
                    dialog.show();
                }
                catch (Exception ex) {
                    ExceptionHandler.reportException(ex);
                }
            }
        });
    }

    public void setTaskTree(TaskTree task) {
        this.taskTree = task;
    }

    public void initializeImages() {
        int i;
        GuiController gui = GuiController.getInstance();
        this.nodeFile = gui.getImage("Node_File.png");
        this.nodeDirectory = gui.getImage("Node_Directory.png");
        this.nodeUndefined = gui.getImage("Node_Undefined.png");
        this.locationSource = gui.getImage("Location_Source.png");
        this.locationDestination = gui.getImage("Location_Destination.png");
        this.locationBoth = gui.getImage("Location_Both.png");
        this.actionImages = new Hashtable();
        for (i = 0; i < Action.names.length; ++i) {
            this.actionImages.put(i, gui.getImage("Action_" + Action.names[i] + ".png"));
        }
        for (i = 0; i < Action.errorNames.length; ++i) {
            this.actionImages.put(i + 10, gui.getImage("Action_" + Action.errorNames[i] + ".png"));
        }
        this.taskImages = new Hashtable();
    }

    public void dispose() {
        this.nodeFile.dispose();
        this.nodeDirectory.dispose();
        this.nodeUndefined.dispose();
        this.locationSource.dispose();
        this.locationDestination.dispose();
        this.locationBoth.dispose();
        for (Image i : this.actionImages.values()) {
            i.dispose();
        }
        for (Image i : this.taskImages.values()) {
            i.dispose();
        }
        super.dispose();
    }

    protected void drawSide(GC g, Task t, Action a, int location) {
        int x;
        File n = t == null ? null : (location == 1 ? t.getSource() : t.getDestination());
        int n2 = x = location == 1 ? 2 : 34;
        if (n == null) {
            g.drawImage(this.nodeUndefined, x, 0);
        } else if (n.exists()) {
            if (n.isDirectory()) {
                g.drawImage(this.nodeDirectory, x, 0);
            } else {
                g.drawImage(this.nodeFile, x, 0);
            }
        }
        if ((a.getLocation() & location) > 0) {
            Image actionImage = this.actionImages.get(a.getType());
            if (actionImage != null) {
                g.drawImage(actionImage, x, 0);
            }
            if (location == 1) {
                g.drawImage(this.locationSource, x + 16, 0);
            } else {
                g.drawImage(this.locationDestination, x - 16, 0);
            }
        }
    }

    protected void drawLocation(GC g, Action a) {
        switch (a.getLocation()) {
            case 1: {
                g.drawImage(this.locationSource, 18, 0);
                break;
            }
            case 2: {
                g.drawImage(this.locationDestination, 18, 0);
                break;
            }
            case 3: {
                g.drawImage(this.locationBoth, 18, 0);
            }
        }
    }

    protected Integer calcTaskImageHash(Task t, Action a) {
        int hash = 0;
        if (t == null) {
            hash |= 1;
        } else {
            File src = t.getSource();
            File dst = t.getDestination();
            if (src.exists()) {
                hash |= 2;
                if (src.isDirectory()) {
                    hash |= 4;
                }
            }
            if (dst.exists()) {
                hash |= 8;
                if (dst.isDirectory()) {
                    hash |= 0x10;
                }
            }
        }
        hash |= a.getLocation() << 6;
        return hash |= a.getType() << 8;
    }

    protected Image buildTaskImage(Task t, Action a) {
        ImageData data = new ImageData(50, 16, 8, new PaletteData(255, 255, 255));
        data.transparentPixel = data.palette.getPixel(new RGB(0, 0, 0));
        Image image = new Image(null, data);
        GC g = new GC((Drawable)image);
        this.drawSide(g, t, a, 1);
        this.drawSide(g, t, a, 2);
        this.drawLocation(g, a);
        g.dispose();
        return image;
    }

    protected Image getTaskImage(Task t, Action a) {
        Integer key = this.calcTaskImageHash(t, a);
        Image image = this.taskImages.get(key);
        if (image == null) {
            image = this.buildTaskImage(t, a);
            this.taskImages.put(key, image);
        }
        return image;
    }

    protected Image getTaskImage(Action a) {
        return this.getTaskImage(null, a);
    }

    protected Image getTaskImage(Task t) {
        return this.getTaskImage(t, t.getCurrentAction());
    }

    protected void addTaskChildren(Task task) {
        for (Task t : task.getChildren()) {
            this.addTask(t);
        }
    }

    protected void addTask(Task t) {
        if (!this.onlyChanges || t.getCurrentAction().getType() != 0) {
            TableItem item;
            Image image = this.getTaskImage(t);
            if (this.tableLogLinesFillIndex < this.tableLogLinesFillCount) {
                item = this.tableLogLines.getItem(this.tableLogLinesFillIndex);
                ++this.tableLogLinesFillIndex;
            } else {
                item = new TableItem(this.tableLogLines, 0);
                ++this.tableLogLinesFillIndex;
                ++this.tableLogLinesFillCount;
            }
            item.setImage(2, image);
            item.setText(new String[]{t.getSource().getPath(), this.formatSize(t), "", t.getCurrentAction().getExplanation()});
            item.setData((Object)t);
            this.taskItemMap.put(t, item);
        }
        this.addTaskChildren(t);
    }

    private String formatSize(Task t) {
        long size = -1L;
        Action action = t.getCurrentAction();
        if (action.getType() == 1 || action.getType() == 2) {
            switch (action.getLocation()) {
                case 1: {
                    size = t.getDestination().getSize();
                    break;
                }
                case 2: {
                    size = t.getSource().getSize();
                    break;
                }
            }
        }
        return UISettings.formatSize(size);
    }

    protected void updateTask(TableItem item) {
        Task t = (Task)item.getData();
        Image image = this.getTaskImage(t);
        item.setImage(2, image);
        item.setText(3, t.getCurrentAction().getExplanation());
    }

    public void rebuildActionList() {
        this.tableLogLinesFillIndex = 0;
        this.tableLogLinesFillCount = this.tableLogLines.getItemCount();
        this.setRedraw(false);
        this.addTaskChildren(this.taskTree.getRoot());
        this.setRedraw(true);
        if (this.tableLogLinesFillIndex < this.tableLogLinesFillCount) {
            this.tableLogLines.setItemCount(this.tableLogLinesFillIndex);
            this.tableLogLinesFillCount = this.tableLogLines.getItemCount();
        }
    }

    protected void showPopup(int x, int y) {
        final TableItem[] tableItemList = this.tableLogLines.getSelection();
        if (tableItemList.length == 0) {
            return;
        }
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Action targetAction = (Action)e.widget.getData();
                for (TableItem item : tableItemList) {
                    Task task = (Task)item.getData();
                    Action[] actions = task.getActions();
                    for (int iAction = 0; iAction < actions.length; ++iAction) {
                        Action a = actions[iAction];
                        if (a.getType() != targetAction.getType() || a.getLocation() != targetAction.getLocation() || !a.getExplanation().equals(targetAction.getExplanation())) continue;
                        task.setCurrentAction(iAction);
                        break;
                    }
                    TaskDecisionList.this.updateTask(item);
                }
            }
        };
        Task[] taskList = new Task[tableItemList.length];
        for (int i = 0; i < tableItemList.length; ++i) {
            taskList[i] = (Task)tableItemList[i].getData();
        }
        Menu m = new Menu((Control)this);
        Action[] possibleActions = (Action[])taskList[0].getActions().clone();
        for (int iTask = 1; iTask < taskList.length; ++iTask) {
            Action[] actions = taskList[iTask].getActions();
            for (int iPosAction = 0; iPosAction < possibleActions.length; ++iPosAction) {
                Action action = possibleActions[iPosAction];
                boolean found = false;
                if (action == null) continue;
                for (Action a : actions) {
                    if (a.getType() != action.getType() || a.getLocation() != action.getLocation() || !a.getExplanation().equals(action.getExplanation())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                possibleActions[iPosAction] = null;
            }
        }
        Task referenceTask = taskList.length == 1 ? taskList[0] : null;
        for (Action action : possibleActions) {
            if (action == null) continue;
            Image image = this.getTaskImage(referenceTask, action);
            MenuItem mi = new MenuItem(m, 0);
            mi.setImage(image);
            mi.setText(Action.toString(action.getType()) + " - " + action.getExplanation());
            mi.setData((Object)action);
            mi.addSelectionListener((SelectionListener)selListener);
        }
        m.setLocation(this.tableLogLines.toDisplay(x, y));
        m.setVisible(true);
    }

    public void setOnlyChanges(boolean onlyChanges) {
        this.onlyChanges = onlyChanges;
    }

    public boolean isChangeAllowed() {
        return this.changeAllowed;
    }

    public void setChangeAllowed(boolean changeAllowed) {
        this.changeAllowed = changeAllowed;
    }

    public void showItem(TableItem item) {
        this.tableLogLines.showItem(item);
    }

    protected void tableLogLinesMouseUp(MouseEvent evt) {
        if (this.changeAllowed && evt.button == 3) {
            this.showPopup(evt.x, evt.y);
        }
    }

    public TableItem getTableItemForTask(Task task) {
        return this.taskItemMap.get(task);
    }
}

